theory question_17_1

imports Main

begin

typedecl entity
typedecl event

consts
  Plants :: "entity ⇒ bool"
  Producers :: "entity ⇒ bool"
  Consumers :: "entity ⇒ bool"
  Omnivores :: "entity ⇒ bool"
  TrophicLevel :: "entity ⇒ nat"
  Feed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Plants are producers and consumers. *)
axiomatization where
  explanation_1: "∀x. Plants x ∧ Producers x ∧ Consumers x"

(* Explanation 2: Omnivores can feed at more than one trophic level. *)
axiomatization where
  explanation_2: "∀x y e. Omnivores x ∧ TrophicLevel y ∧ Feed e ∧ Agent e x ∧ Patient e y"

theorem hypothesis:
  assumes asm: "Omnivores x ∧ TrophicLevel y"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃x y e. Feed e ∧ Agent e x ∧ Patient e y ∧ TrophicLevel y"
proof -
  from asm have "Omnivores x ∧ TrophicLevel y" by simp
  then obtain e where e: "Feed e ∧ Agent e x ∧ Patient e y" using explanation_2 by blast
  show ?thesis using asm e by simp
qed

end
