theory question_81_5
imports Main
begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  Forest :: "entity ⇒ bool"
  Environment :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Soil is a kind of nonliving thing. *)
axiomatization where
  explanation_1: "∀x. Soil x ⟶ Nonliving x"

(* Explanation 2: A forest is a kind of environment. *)
axiomatization where
  explanation_2: "∀x. Forest x ⟶ Environment x"

(* Explanation 3: Soil is usually part of an environment, including forests. *)
axiomatization where
  explanation_3: "∀x y. Soil x ∧ Environment y ∧ Forest y ⟶ PartOf x y"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧  ∃y. Forest y ∧ PartOf x y "
proof -
  from asm have "Soil x" by simp
  then have "Nonliving x" using explanation_1 by blast
  then obtain y where "Forest y ∧ PartOf x y" using explanation_3 by blast
  thus ?thesis using `Nonliving x` by blast
qed

end
