'''
Date: 2021-06-10 18:16:13
LastEditors: Wu Xianze (wuxianze.0@bytedance.com)
LastEditTime: 2021-06-10 20:26:31
'''
import os
import json

def readTxt(path):
    datas = []
    with open(path, 'r') as fin:
        for line in fin:
            datas.append(line.strip())
    print("Reading {} example from {}".format(len(datas), path))
    return datas

def saveTxt(data, fname):
    with open(fname, 'w') as fout:
        for d in data:
            fout.write('{}\n'.format(d))
    print('Save {} example to {}'.format(len(data), fname))

def readJsonl(fname):
    datas = []
    with open(fname, 'r') as fin:
        for line in fin:
            datas.append(json.loads(line.strip()))
    return datas

def dumpJsonl(datas, fname):
    with open(fname, 'w') as fout:
        for data in datas:
            fout.write(json.dumps(data, ensure_ascii=False) + '\n')

def getfiles(path):
    if os.path.isdir(path):
        files = [os.path.join(path, f) for f in os.listdir(path)]
        files = sorted(files)
    else:
        files = [path]
    return files