import sympy

""" Maximum capacity of variable, numbers and equation memories """
VAR_MAX = 9  #: MAX NUMBER OF MAXIMUM VARIABLES (FOR EXPLANATION DECODER)
NUM_MAX = 16 + VAR_MAX  #: MAX NUMBER OF WRITTEN NUMBERS IN THE TEXT (INCLUDE VAR PLACEHOLDER)
RES_MAX = 64  #: MAX NUMBER OF Equation TOKENS
TXT_MAX = 192  #: MAX NUMBER OF TOKENS IN THE TEXT
EXPL_MAX = 40  #: MAX NUMBER OF TOKENS FOR EACH EXPLANATION
VOCAB_MAX = 30000  #: FALLBACK VALUE FOR SIZE OF THE VOCAB

""" Format of variable/number/equation tokens """
PREFIX_LEN = 2  #: LENGTH OF OPERAND-SOURCE PREFIX
VAR_PREFIX = 'X_'  #: PREFIX FOR VARIABLES
NUM_PREFIX = 'N_'  #: PREFIX FOR WRITTEN NUMBERS
RES_PREFIX = 'R_'  #: PREFIX FOR PREVIOUSLY COMPUTED VALUES
VAR_FORMAT = '%s%%02d' % VAR_PREFIX  #: FORMAT FOR VARIABLE ID
NUM_FORMAT = '%s%%02d' % NUM_PREFIX  #: FORMAT FOR NUMBER ID
RES_FORMAT = '%s%%02d' % RES_PREFIX  #: FORMAT FOR RESULT ID
assert len(VAR_PREFIX) == PREFIX_LEN and len(NUM_PREFIX) == PREFIX_LEN and len(RES_PREFIX) == PREFIX_LEN

""" Simple constant tokens """
#: LIST OF CONSTANT TOKEN STRINGS
CON_TOKENS = [
    '0',
    '0.01',
    '0.05',
    '0.1',
    '0.25',
    '0.5',
    '1',
    '2',
    '3',
    '3.14',
    '4',
    '5',
    '6',
    '7',
    '8',
    '9',
    '10',
    '12',
    '25',
    '50',
    '60',
    '100',
    '180'
]
#: LIST OF SYMPY NUMBER FOR EACH CONSTANT TOKENS
CON_VALUES = [sympy.Number(v) for v in CON_TOKENS]

""" Position of each operand source """
CON_END = len(CON_TOKENS)  #: LAST INDEX OF CONSTANTS + 1
NUM_BEGIN = CON_END  #: BEGIN POSITION OF NUMBERS
NUM_END = NUM_BEGIN + NUM_MAX  #: LAST INDEX OF NUMBERS + 1
RES_BEGIN = NUM_END  #: BEGIN POSITION OF RESULTS

""" Token for operand sources """
SRC_CONSTANT = 0  #: SOURCE KEY FOR CONSTANTS
SRC_NUMBER = 1  #: SOURCE KEY FOR NUMBERS
SRC_RESULT = 2  #: SOURCE KEY FOR PREVIOUSLY COMPUTED RESULTS
SRC_LIST = [SRC_CONSTANT, SRC_NUMBER, SRC_RESULT]  #: LIST OF SOURCE KEYS
