export SEED=49
export SAVE_STEPS=500
export EVAL_STEPS=500
export ENCODER_TYPE=BERT
export LAYERS=2
export HIDDEN_SIZE=128
export FILTER=1
export MAX_NUMBER_OF_STEPS=15000

export BATCH_SIZE=256
export MULTIVARIATE_LOSS="RAO"
export LR=0.000001 # un de moins
for DATASET in "dial_sentiment" "dial_mention" 'pan_age' 'pan_gender'; do
  for MUL in 0.001 0.01 0.1 1 10; do
    export FBLOCK="MI"
    export MI="ADV"
    export RENY_TRAINING=3
    export ALPHA=1.5
    for MI in "ADV" "MIReny"; do
      export OUTPUT_DIR=nclassif_${DATASET}_${FBLOCK}_${MI}_${MUL}_${ENCODER_TYPE}
      echo $OUTPUT_DIR
      export RENY_TRAINING=3
      export ALPHA=1.5
      sbatch --job-name=${OUTPUT_DIR} \
        --gres=gpu:1 \
        --no-requeue \
        --cpus-per-task=3 \
        --hint=nomultithread \
        --time=5:00:00 \
        --output=jobinfo/${OUTPUT_DIR}_%j.out \
        --error=jobinfo/${OUTPUT_DIR}_%j.err \
        --qos=qos_gpu-t4 \
        --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;  python3 train.py --max_number_of_steps=$MAX_NUMBER_OF_STEPS --warmup_steps=4000 --seed=$SEED --output_dir=$OUTPUT_DIR --eval_step=$EVAL_STEPS --save_step=$SAVE_STEPS --encoder_type=$ENCODER_TYPE --number_of_layers=$LAYERS --hidden_size=$HIDDEN_SIZE --filter=$FILTER --fblock=$FBLOCK --multi_loss_type=$MULTIVARIATE_LOSS --mi_estimator_name=$MI --alpha=$ALPHA --number_of_training_encoder=$RENY_TRAINING --mul_lambda=$MUL --dataset=$DATASET --batch_size=$BATCH_SIZE  --learning_rate=$LR "

    done

    export FBLOCK="MULTI"
    for MULTIVARIATE_LOSS in "SINKHORN" "ENERGY" "RAO" "ENERGY" "FRECHET" "JS"; do
      export OUTPUT_DIR=viz_attempt_nclassif_${DATASET}_${FBLOCK}_${MULTIVARIATE_LOSS}_${MUL}_${ENCODER_TYPE}_${LR}
      echo $OUTPUT_DIR
      sbatch --job-name=${OUTPUT_DIR} \
        --gres=gpu:1 \
        --no-requeue \
        --cpus-per-task=3 \
        --hint=nomultithread \
        --time=5:00:00 \
        --output=jobinfo/${OUTPUT_DIR}_%j.out \
        --error=jobinfo/${OUTPUT_DIR}_%j.err \
        --qos=qos_gpu-t4 \
        --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;  python3 train.py --warmup_steps=4000 --max_number_of_steps=$MAX_NUMBER_OF_STEPS --seed=$SEED --output_dir=$OUTPUT_DIR --eval_step=$EVAL_STEPS --save_step=$SAVE_STEPS --encoder_type=$ENCODER_TYPE --number_of_layers=$LAYERS --hidden_size=$HIDDEN_SIZE --filter=$FILTER --fblock=$FBLOCK --multi_loss_type=$MULTIVARIATE_LOSS --mi_estimator_name=$MI --alpha=$ALPHA --number_of_training_encoder=$RENY_TRAINING --mul_lambda=$MUL --dataset=$DATASET --batch_size=$BATCH_SIZE  --learning_rate=$LR "

    done

  done

done

export SEED=49
export SAVE_STEPS=500
export EVAL_STEPS=500
export ENCODER_TYPE=BERT
export LAYERS=2
export HIDDEN_SIZE=128
export FILTER=1
export MAX_NUMBER_OF_STEPS=15000

export BATCH_SIZE=256
export MULTIVARIATE_LOSS="RAO"
export LR=0.000001
for DATASET in "dial_sentiment" "dial_mention" 'pan_age' 'pan_gender'; do
  for MUL in 0.001 0.01 0.1 1 10; do
    export FBLOCK="MI"
    export MI="ADV"
    export RENY_TRAINING=3
    export ALPHA=1.5
    for MI in "ADV" "MIReny"; do
      export OUTPUT_DIR=nclassif_${DATASET}_${FBLOCK}_${MI}_${MUL}_${ENCODER_TYPE}
      echo $OUTPUT_DIR
      export RENY_TRAINING=3
      export ALPHA=1.5
      sbatch --job-name=${OUTPUT_DIR} \
        --gres=gpu:1 \
        --no-requeue \
        --cpus-per-task=3 \
        --hint=nomultithread \
        --time=5:00:00 \
        --output=jobinfo/${OUTPUT_DIR}_%j.out \
        --error=jobinfo/${OUTPUT_DIR}_%j.err \
        --qos=qos_gpu-t4 \
        --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;  python3 train.py --max_number_of_steps=$MAX_NUMBER_OF_STEPS --warmup_steps=4000 --seed=$SEED --output_dir=$OUTPUT_DIR --eval_step=$EVAL_STEPS --save_step=$SAVE_STEPS --encoder_type=$ENCODER_TYPE --number_of_layers=$LAYERS --hidden_size=$HIDDEN_SIZE --filter=$FILTER --fblock=$FBLOCK --multi_loss_type=$MULTIVARIATE_LOSS --mi_estimator_name=$MI --alpha=$ALPHA --number_of_training_encoder=$RENY_TRAINING --mul_lambda=$MUL --dataset=$DATASET --batch_size=$BATCH_SIZE  --learning_rate=$LR "

    done

    export FBLOCK="MULTI"
    for MULTIVARIATE_LOSS in "SINKHORN" "ENERGY" "RAO" "ENERGY" "FRECHET" "JS"; do
      export OUTPUT_DIR=viz_attempt_nclassif_${DATASET}_${FBLOCK}_${MULTIVARIATE_LOSS}_${MUL}_${ENCODER_TYPE}_${LR}
      echo $OUTPUT_DIR
      sbatch --job-name=${OUTPUT_DIR} \
        --gres=gpu:1 \
        --no-requeue \
        --cpus-per-task=3 \
        --hint=nomultithread \
        --time=5:00:00 \
        --output=jobinfo/${OUTPUT_DIR}_%j.out \
        --error=jobinfo/${OUTPUT_DIR}_%j.err \
        --qos=qos_gpu-t4 \
        --wrap="module purge; module load pytorch-gpu/py3/1.7.0 ;  python3 train.py --warmup_steps=4000 --max_number_of_steps=$MAX_NUMBER_OF_STEPS --seed=$SEED --output_dir=$OUTPUT_DIR --eval_step=$EVAL_STEPS --save_step=$SAVE_STEPS --encoder_type=$ENCODER_TYPE --number_of_layers=$LAYERS --hidden_size=$HIDDEN_SIZE --filter=$FILTER --fblock=$FBLOCK --multi_loss_type=$MULTIVARIATE_LOSS --mi_estimator_name=$MI --alpha=$ALPHA --number_of_training_encoder=$RENY_TRAINING --mul_lambda=$MUL --dataset=$DATASET --batch_size=$BATCH_SIZE  --learning_rate=$LR "

    done

  done

done
