import pathlib

import pydantic


class PipelineConf(pydantic.BaseSettings):
    EMBEDDING_METHOD: str
    CLASSIFICATION_METHOD: str


def from_path(path):
    path = pathlib.Path(path)
    source = path.read_text()
    module_globals = {}
    exec(source, module_globals)
    obj = {}
    for k in PipelineConf.__fields__:
        if k in module_globals:
            obj[k] = module_globals[k]
    return PipelineConf.parse_obj(obj)
