import boto3
import json
try:
    from secret import *
except:
    import sys
    print("""In order to use this code you need to create a file 'secret.py' containing:

aws_access_key_id = 'Your AWS access key ID'
aws_secret_access_key = 'Your AWS secret access key'""")
    sys.exit(1)

def get_client(sandbox):
    region_name = 'us-east-1'

    endpoint_url = 'https://mturk-requester.us-east-1.amazonaws.com'
    if sandbox:
        print("Applying to SANDBOX")
        endpoint_url = 'https://mturk-requester-sandbox.us-east-1.amazonaws.com'

    client = boto3.client(
        'mturk',
        endpoint_url=endpoint_url,
        region_name=region_name,
        aws_access_key_id=aws_access_key_id,
        aws_secret_access_key=aws_secret_access_key,
    )

    return client
