/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.parser.lexparser.LatticeEdge;
import edu.stanford.nlp.parser.lexparser.ParserConstraint;
import edu.stanford.nlp.util.Generics;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Lattice
implements Serializable,
Iterable<LatticeEdge> {
    private static final long serialVersionUID = 5135076134500512556L;
    private final List<ParserConstraint> constraints;
    private final List<LatticeEdge> edges = new ArrayList<LatticeEdge>();
    private final Set<Integer> nodes = Generics.newHashSet();
    private final Map<Integer, List<LatticeEdge>> edgeStartsAt;
    private int maxNode = -1;

    public Lattice() {
        this.constraints = new ArrayList<ParserConstraint>();
        this.edgeStartsAt = Generics.newHashMap();
    }

    public void addEdge(LatticeEdge e) {
        this.nodes.add(e.start);
        this.nodes.add(e.end);
        this.edges.add(e);
        if (e.end > this.maxNode) {
            this.maxNode = e.end;
        }
        if (this.edgeStartsAt.get(e.start) == null) {
            ArrayList<LatticeEdge> edges = new ArrayList<LatticeEdge>();
            edges.add(e);
            this.edgeStartsAt.put(e.start, edges);
        } else {
            this.edgeStartsAt.get(e.start).add(e);
        }
    }

    public void addConstraint(ParserConstraint c) {
        this.constraints.add(c);
    }

    public int getNumNodes() {
        return this.nodes.size();
    }

    public List<ParserConstraint> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public int getNumEdges() {
        return this.edges.size();
    }

    public List<LatticeEdge> getEdgesOverSpan(int start, int end) {
        List<LatticeEdge> allEdges = this.edgeStartsAt.get(start);
        ArrayList<LatticeEdge> spanningEdges = new ArrayList<LatticeEdge>();
        if (allEdges != null) {
            for (LatticeEdge e : allEdges) {
                if (e.end != end) continue;
                spanningEdges.add(e);
            }
        }
        return spanningEdges;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("[ Lattice: %d edges  %d nodes ]\n", this.edges.size(), this.nodes.size()));
        for (LatticeEdge e : this.edges) {
            sb.append("  " + e.toString() + "\n");
        }
        return sb.toString();
    }

    public void setEdge(int id, LatticeEdge e) {
        this.edges.set(id, e);
    }

    @Override
    public Iterator<LatticeEdge> iterator() {
        return this.edges.iterator();
    }

    public void addBoundary() {
        LatticeEdge boundary = new LatticeEdge(".$.", 0.0, this.maxNode, this.maxNode + 1);
        this.addEdge(boundary);
    }
}

