/*
 * graph_DDdecoder_3tree.cpp
 *
 *  Created on: Dec 23, 2015
 *      Author: ytdu
 */

#include "graph_DDdecoder_graph_graph_gg2gc.h"

namespace graph_merging_2gc {
int graph_DDdecoder_graph_graph::tags[] = {0, 1};

graph_DDdecoder_graph_graph::graph_DDdecoder_graph_graph(const std::string& model_graphA,
		const std::string& model_graphB,int step) {
	std::cout << model_graphA << ' ' << model_graphB << std::endl;
	graphParA = new graphcjj2gc_prune::DepParser(model_graphA, model_graphA, ParserState::PARSE);
	graphParB = new graphcjj2gc_prune::DepParser(model_graphB, model_graphB, ParserState::PARSE);
	for (int i = 0; i < max_iter; ++i) {
		steps.push_back(step * (max_iter - i) / max_iter);
	}
	optimal_count = std::vector<int>(max_iter + 1, 0);
}

graph_DDdecoder_graph_graph::~graph_DDdecoder_graph_graph() {
	delete graphParA;
	delete graphParB;
}

void graph_DDdecoder_graph_graph::decode(const DependencyGraph &test, DependencyGraph &retval_graphA,
	DependencyGraph &retval_graphB) {
	Sentence sent = test.getSentence();
	DependencyTree deptree = test.getTree();
	graphParA->m_vecDependencyTree = deptree;
	graphParA->parse(test, &retval_graphA);
	graphParB->m_vecDependencyTree = deptree;
	graphParB->parse(test, &retval_graphB);
	int iter = 0;
	for (; iter < max_iter; ++iter) {
		//std::cout << iter << std::endl;
		if (is_coordinate(retval_graphA, retval_graphB, iter)) {
			std::cout<<"Solution found in iter "<<iter<<std::endl;
			optimal_count[iter]++;
			return;
		}
		//std::cout << "begin dd" << std::endl;
		retval_graphA.m_lGraph.clear();
		retval_graphB.m_lGraph.clear();
		graphParA->work_after_scoring(&retval_graphA, test);
		graphParB->work_after_scoring(&retval_graphB, test);
	}
	std::cout<<"Solution found in iter "<<iter<<std::endl;
	optimal_count[iter]++;
}

int check_coordinate(int x1,int x2,int y1,int y2){
	if (x1 > x2) std::swap(x1,x2);
	if (y1 > y2) std::swap(y1,y2);
	if (x1 == y1 && x2 == y2)
		return 1;
	if ( (x1 - y1) * (x1 - y2) * (x2 - y1) * (x2 - y2) < 0)
		return 1;
	return 0;
}

bool graph_DDdecoder_graph_graph::is_coordinate(const DependencyGraph &graphA,
		const DependencyGraph &graphB, int iter) {
	bool is_coord = true;
	for (auto &edgeA : graphA.getGraph()){
		int flag = 0;
		int from = EDGE_X(edgeA),to = EDGE_Y(edgeA);
		int label = graphParA->DepLabel.code(EDGE_LABEL(edgeA));
		for (auto &edgeB : graphB.getGraph())
			if (check_coordinate(EDGE_X(edgeA),EDGE_Y(edgeA),EDGE_X(edgeB),EDGE_Y(edgeB))){
				flag = 1;
				break;
			}

		if (flag == 0){
			is_coord = false;
			graphParA->Score_single[from][to][2*label] -= steps[iter];
			graphParA->Score_single[to][from][2*label+1] -= steps[iter];
			graphParB->Score_single[from][to][2*label] += steps[iter];
			graphParB->Score_single[to][from][2*label+1] += steps[iter];
		}
	}
	for (auto &edgeA : graphB.getGraph()){
			int flag = 0;
			int from = EDGE_X(edgeA),to = EDGE_Y(edgeA);
			int label = graphParB->DepLabel.code(EDGE_LABEL(edgeA));
			for (auto &edgeB : graphA.getGraph())
				if (check_coordinate(EDGE_X(edgeA),EDGE_Y(edgeA),EDGE_X(edgeB),EDGE_Y(edgeB))){
					flag = 1;
					break;
				}

			if (flag == 0){
				is_coord = false;
				graphParB->Score_single[from][to][2*label] -= steps[iter];
				graphParB->Score_single[to][from][2*label+1] -= steps[iter];
				graphParA->Score_single[from][to][2*label] += steps[iter];
				graphParA->Score_single[to][from][2*label+1] += steps[iter];
			}
		}
	return is_coord;
}

}

