/*
 * graph_DDDecoder_3Tree.h
 *
 *  Created on: Dec 23, 2015
 *      Author: ytdu
 */

//#ifndef COMMON_PARSER_IMPLEMENTATIONS_GRAPH_MERGING_GRAPH_DDDECODER_TREE_GRAPH_H_
//#define COMMON_PARSER_IMPLEMENTATIONS_GRAPH_MERGING_GRAPH_DDDECODER_TREE_GRAPH_H_

#include<memory>

#include "common/parser/implementations/graph_dp_cjj/graphcjj1L/graphcjj1L_depparser.h"

namespace graph_merging_1L {
class graph_DDdecoder_graph_graph {
private:
	static int tags[];
	graphcjj1L::DepParser* graphParA;
	graphcjj1L::DepParser* graphParB;
	std::string graphparse_type;
	int null_lab_index;
	bool is_coordinate(const DependencyGraph &graphA,
			const DependencyGraph &graphB, int iter);

public:
	int max_iter = 200;
	std::vector<tscore> steps;
	std::vector<int> optimal_count;

	graph_DDdecoder_graph_graph(const std::string& model_graphA, const std::string& model_graphB, int step);
	~graph_DDdecoder_graph_graph();
	void decode(const DependencyGraph &test, DependencyGraph &retval_graphA,DependencyGraph &retval_graphB);
	void print_optimal_count() {
		std::cout << "Number of optimal solutions found in each iteration:\n[" << optimal_count[0];
		for (int i = 1; i <= max_iter; ++i) {
			std::cout<< "," << optimal_count[i];
		}
		std::cout << "]" << std::endl;
	}
};
}

//#endif /* COMMON_PARSER_IMPLEMENTATIONS_GRAPH_MERGING_GRAPH_DDDECODER_TREE_GRAPH_H_ */
