#ifndef _graphcjj2gc_DEPPARSER_H
#define _graphcjj2gc_DEPPARSER_H

#include <vector>
#include <unordered_set>
#include <unordered_map>
#include <include/learning/tree/lca.h>
#include "common/parser/depgraph.h"
#include "graphcjj2gc_prune_state.h"
#include "graphcjj2gc_prune_weight.h"
#include "common/parser/depparser_base.h"

namespace graph_merging_2gc{
class graph_DDdecoder_tree_graph;
class graph_DDdecoder_graph_graph;
}

namespace graphcjj2gc_prune {
	class DepParser : public DepParserBase {
	private:
		static WordPOSTag empty_taggedword;
		static WordPOSTag start_taggedword;
		static WordPOSTag end_taggedword;

		StateItem m_lItems[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE];
		WordPOSTag m_lSentence[MAX_SENTENCE_SIZE];
		std::vector<PCLArc> m_vecCorrectArcs;
		std::vector<PCLArc> m_vecTrainArcs;
		DependencyTree m_vecDependencyTree;
		LCA m_lcaTree;
		int m_nSentenceLength;

		tscore m_nRetval;

		int m_nDis, m_nDir;

		Word p_word, c_word;
		POSTag p_tag, c_tag;

		WordInt word_int;
		POSTagInt tag_int;

		POSTag p_1_tag, p1_tag, c_1_tag, c1_tag, b_tag;
		Word p_1_word, p1_word, c_1_word, c1_word;

		TwoWordsInt word_word_int;
		POSTagSet2Int tag_tag_int;
		WordPOSTagInt word_tag_int;

		POSTagSet3Int tag_tag_tag_int;
		WordPOSTagPOSTagInt word_tag_tag_int;
		POSTagSet4Int flag_word_tag_tag_int;
		POSTagSet3Int flag_tag_tag_int;
		WordWordPOSTagInt word_word_tag_int;

		POSTagSet4Int tag_tag_tag_tag_int;
		WordWordPOSTagPOSTagInt word_word_tag_tag_int;
		PathInt path_int;
		POSTagInt subcat_int;
		POSTagSet2Int subcat_tag_int,path_tag_int;
		LabelInt label_int;
		std::unordered_set<PCLArc> m_setFirstGoldScore;
		std::unordered_set<PC1L1C2L2Arc> m_setSecondGoldScore;
		std::unordered_set<PC1L1C2L2Arc> m_setGCGoldScore;

//		tscore Score_single[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE][2*MAX_LABEL_SIZE];
		//cjj
		//tscore Score_sibling[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE][2*MAX_LABEL_SIZE][MAX_SENTENCE_SIZE][2*MAX_LABEL_SIZE];
		//tscore Score_gc[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE][2*MAX_LABEL_SIZE][MAX_SENTENCE_SIZE][2*MAX_LABEL_SIZE];
		
		std::unordered_map<PC1L1C2L2Arc,tscore> Score_sibling;
		std::unordered_map<PC1L1C2L2Arc,tscore> Score_gc;

		void update();
		void generate(DependencyGraph * retval, const DependencyGraph & correct);
		void goldCheck();

		tscore arcScore_single(const int & p, const int & c , const int & label);
		tscore arcScore_sibling(const int & p, const int & c, const int & la1, const int &mid, const int & la2);
		tscore arcScore_gc(const int & p, const int & c, const int & la1, const int &mid, const int & la2);

		void getOrUpdateStackScore_single(const int & p, const int & c, const int & label, const int & amount = 0);
		void getOrUpdateStackScore_sibling(const int & p, const int & c1, const int &la1, const int & c2, const int &la2, const int & amount = 0);
		void getOrUpdateStackScore_gc(const int & p, const int & c1, const int &la1, const int & c2, const int &la2, const int & amount = 0);
		
		void InitScore_single();
		void InitScore_sibling();
		void InitScore_gc();

		void update_sibling();
		void update_gc();

		void getArc(int l, int r);
	
	public:
		tscore Score_single[MAX_SENTENCE_SIZE][MAX_SENTENCE_SIZE][2*MAX_LABEL_SIZE];
		DepParser(const std::string & sFeatureInput, const std::string & sFeatureOut, int nState);
		~DepParser();
		void outans();
		void decode() override;
		void decode_after_scoring();
		void decodeArcs() override;
		void train(const DependencyGraph & correct, const int & round);
		void parse(const DependencyGraph & graph, DependencyGraph * retval);
		void work(DependencyGraph * retval, const DependencyGraph & correct);
		void work_after_scoring(DependencyGraph * retval, const DependencyGraph & correct);
		friend class graph_merging_2gc::graph_DDdecoder_tree_graph;
		friend class graph_merging_2gc::graph_DDdecoder_graph_graph;
	};
}

#endif
