clc
clear
%%%%%%data
disp('Train the RL-DNN-LM on wiki database');
%%%%%%%%%
para.n_words         = 2; 
para.vecSize         = 200;
%%%%
word2vector_init_method  = 'random'; %random skip_gram
%% Data prepcessing
[D] = DataProcessing(para.vecSize,para.n_words, word2vector_init_method);
%load('../data/DNNLM.WIKI.80k.200.random.n_words1.mat');
%%%%%%%%%% parameters setting
para.lrate           = 0.6;
para.batchSize       = 500;
para.NNsize          = [para.vecSize*para.n_words,400,400,D.codeBookSize]; %% net architecture
para
%%%%%%%%%%training
[net,codeBook, obj] = RL_DNN_LM(D, para);
%%%%%%%%%%save
nLayers = length(para.NNsize);
w = cell(1,nLayers-1);
bias = cell(1,nLayers-1);
for iLayer = 1 : nLayers-1
    w{iLayer} = gather(net.w{iLayer});
    bias{iLayer} = gather(net.b{iLayer});
end
%fname=datestr(now);
fname = sprintf('./rec/DNNLM.wiki.80k.%dgram_vecSize%d_lr%.2f_b%d_2hid400_%s',para.vecSize,para.n_words,para.lrate,para.batchSize,word2vector_init_method);
save(fname, 'w', 'bias','obj','para','codeBook') ;   