function ppl =  Calculate_ppl(data, t, net, para, SHIFT_VECTOR)
%
%  ppl =  Calculate_ppl(data, targets, net, para, SHIFT_VECTOR)
% 
%  data: batchSize * frameSize.
%  targets: batchSize * nTargets
%  net:  the network to be trained, it should be built and initialized
%  para: some parameters define

nLayers = length(para.NNsize);
%******* Forward
%%Input layer
iLayer = 1;
x = bsxfun(@plus, data * net.w{iLayer}, net.b{iLayer});
y = x.*(x > 0);%%%ReLUs activation function 
%%%%%%%%%%%%%
%%hidden layer
for iLayer = 2 : nLayers-2
  %activation
  x = bsxfun(@plus, y * net.w{iLayer}, net.b{iLayer});
  y = x.*(x > 0);%%%ReLUs activation function 
end
%%%%%%%%%%%output layer
iLayer = nLayers-1;
%%softmax layer
x = exp(bsxfun(@plus, y * net.w{iLayer}, net.b{iLayer}));
y = bsxfun(@rdivide, x, sum(x,2));
%%%%perplexity
%targets = full(sparse(1:size(y,1),t,1,size(y,1),size(y,2)));
%ppl = sum(log(y(logical(targets))),1);
%ppl = sum(log(sum(y.*targets,2)),1);
ind = t + SHIFT_VECTOR;
y = y';
ppl = sum(log(y(ind)));



