/*
 * Decompiled with CFR 0.152.
 */
package matetools.is2.modification.morefeatures;

import java.util.ArrayList;
import java.util.List;
import matetools.is2.data.Instances;
import matetools.is2.data.Long2IntInterface;
import matetools.is2.data.SentenceData09;
import matetools.is2.modification.morefeatures.DepTreeFeatures;
import matetools.is2.modification.morefeatures.GraphFeatures;
import matetools.is2.modification.morefeatures.MRSFeatures;
import matetools.is2.parser.MFO;

public abstract class MoreFeaturesInterface {
    public static List<MoreFeaturesInterface> mfis;
    public static Long2IntInterface l2i;
    protected MFO mf = new MFO();
    protected int featureIndex;

    public static void initialize(String moreFeatures) {
        mfis = new ArrayList<MoreFeaturesInterface>();
        if (moreFeatures == null) {
            return;
        }
        System.out.println("Using more features: \"" + moreFeatures + "\"");
        Option opt = new Option(moreFeatures);
        if (opt.trainMRSdir != null || opt.testMRSdir != null) {
            mfis.add(new MRSFeatures(opt.trainMRSdir, opt.testMRSdir));
        }
        if (opt.trainDepDir != null || opt.testDepDir != null) {
            mfis.add(new DepTreeFeatures(opt.trainDepDir, opt.testDepDir, opt.depFormat));
        }
        if (opt.trainGraphDir != null || opt.testGraphDir != null) {
            mfis.add(new GraphFeatures(opt.trainGraphDir, opt.testGraphDir, opt.graphFormat));
        }
    }

    public static void initFeatures() {
        for (MoreFeaturesInterface mfi : mfis) {
            mfi.initFeats();
        }
    }

    public static void initStat(int what) {
        for (MoreFeaturesInterface mfi : mfis) {
            mfi.init(what);
        }
    }

    public static void registerAll() {
        for (MoreFeaturesInterface mfi : mfis) {
            mfi.register();
        }
    }

    public static void createMoreFeatures(Instances is, SentenceData09 instance) {
        for (MoreFeaturesInterface mfi : mfis) {
            mfi.createFeatures(is, instance);
        }
    }

    public static List<Long> moreFeatures(Instances is, int ins, int w1, int w2, int label) {
        ArrayList<Long> ret = new ArrayList<Long>();
        for (MoreFeaturesInterface mfi : mfis) {
            mfi.addFirstOrderFeatures(is, ins, w1, w2, label, ret);
        }
        return ret;
    }

    public static void startReadingAllTrain() {
        for (MoreFeaturesInterface mfi : mfis) {
            mfi.startReadingTrain();
        }
    }

    public static void startReadingAllTest() {
        for (MoreFeaturesInterface mfi : mfis) {
            mfi.startReadingTest();
        }
    }

    public abstract void register();

    public abstract void init(int var1);

    public abstract void initFeats();

    public abstract void createFeatures(Instances var1, SentenceData09 var2);

    public abstract void addFirstOrderFeatures(Instances var1, int var2, int var3, int var4, int var5, List<Long> var6);

    public abstract void startReadingTrain();

    public abstract void startReadingTest();

    public static class MoreIntFeats {
        MRSFeatures.IntMRS mrs;
        DepTreeFeatures.IntDepTree depTree;
        GraphFeatures.IntGraphs graphs;

        public MoreIntFeats(MRSFeatures.IntMRS m) {
            this.mrs = m;
        }

        public MoreIntFeats(DepTreeFeatures.IntDepTree depTree) {
            this.depTree = depTree;
        }

        public MoreIntFeats(GraphFeatures.IntGraphs intGraph) {
            this.graphs = intGraph;
        }
    }

    static class Option {
        String trainMRSdir;
        String testMRSdir;
        String trainDepDir;
        String testDepDir;
        String trainGraphDir;
        String testGraphDir;
        String graphFormat = "sdp15";
        String depFormat = "conll08";

        Option(String s) {
            String[] opts = s.split("\\s+");
            int i = 0;
            while (i < opts.length) {
                if (opts[i].equalsIgnoreCase("-trainMRSdir")) {
                    this.trainMRSdir = opts[++i];
                } else if (opts[i].equalsIgnoreCase("-testMRSdir")) {
                    this.testMRSdir = opts[++i];
                } else if (opts[i].equalsIgnoreCase("-trainDepDir")) {
                    this.trainDepDir = opts[++i];
                } else if (opts[i].equalsIgnoreCase("-testDepDir")) {
                    this.testDepDir = opts[++i];
                } else if (opts[i].equalsIgnoreCase("-depFormat")) {
                    this.depFormat = opts[++i];
                } else if (opts[i].equalsIgnoreCase("-trainGraphs")) {
                    this.trainGraphDir = opts[++i];
                } else if (opts[i].equalsIgnoreCase("-testGraphs")) {
                    this.testGraphDir = opts[++i];
                } else if (opts[i].equalsIgnoreCase("-graphFormat")) {
                    this.graphFormat = opts[++i];
                } else {
                    throw new RuntimeException("Unknown option: " + opts[i]);
                }
                ++i;
            }
        }
    }
}

