/*
 * Decompiled with CFR 0.152.
 */
package fig.html;

import fig.basic.MapUtils;
import fig.basic.StrUtils;
import java.util.HashMap;
import java.util.Map;

public abstract class HtmlElement {
    private Map<String, String> attributes;

    public HtmlElement setId(String id) {
        return this.setAttr("id", id);
    }

    public HtmlElement setAttr(String key) {
        return this.setAttr(key, "");
    }

    public HtmlElement setAttr(String key, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>(2);
        }
        this.attributes.put(key, StrUtils.toString(value));
        return this;
    }

    public String getAttr(String key) {
        return MapUtils.get(this.attributes, key, null);
    }

    public abstract String getTag();

    protected abstract void renderInnerHTML(StringBuilder var1, Map<String, Map<String, String>> var2);

    public void render(StringBuilder sb, Map<String, Map<String, String>> inheritedAttributesSet) {
        Map inheritedAttributes;
        sb.append("<");
        sb.append(this.getTag());
        if (this.attributes != null) {
            for (Map.Entry<String, String> e : this.attributes.entrySet()) {
                this.renderAttr(sb, e);
            }
        }
        if ((inheritedAttributes = (Map)MapUtils.get(inheritedAttributesSet, this.getTag(), null)) != null) {
            for (Map.Entry<String, String> entry : inheritedAttributes.entrySet()) {
                if (this.attributes != null && this.attributes.containsKey(entry.getKey())) continue;
                this.renderAttr(sb, entry);
            }
        }
        sb.append(">");
        this.renderInnerHTML(sb, inheritedAttributesSet);
        sb.append("</");
        sb.append(this.getTag());
        sb.append(">");
        sb.append("\n");
    }

    public void render(StringBuilder sb) {
        this.render(sb, new HashMap<String, Map<String, String>>());
    }

    public String render() {
        StringBuilder sb = new StringBuilder();
        this.render(sb);
        return sb.toString();
    }

    private void renderAttr(StringBuilder sb, Map.Entry<String, String> e) {
        sb.append(' ');
        sb.append(e.getKey());
        if (!StrUtils.isEmpty(e.getValue())) {
            sb.append("=\"");
            sb.append(e.getValue());
            sb.append("\"");
        }
    }
}

