/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.LogInfo;
import fig.basic.StringDoubleMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class String2DoubleMap
implements Iterable<Map.Entry<String, StringDoubleMap>>,
Serializable {
    private static final long serialVersionUID = 42L;
    private boolean locked;
    private Map<String, StringDoubleMap> maps = new HashMap<String, StringDoubleMap>();
    private String lastKey;
    private StringDoubleMap lastMap;

    public boolean containsKey(String key1, String key2) {
        StringDoubleMap map = this.getMap(key1, false);
        return map != null && map.containsKey(key2);
    }

    public double get(String key1, String key2, double defaultValue) {
        StringDoubleMap map = this.getMap(key1, false);
        return map == null ? defaultValue : map.get(key2, defaultValue);
    }

    public double getWithErrorMsg(String key1, String key2, double defaultValue) {
        StringDoubleMap map = this.getMap(key1, false);
        if (map == null) {
            LogInfo.errors("(%s, %s) not in map, using %f", key1, key2, defaultValue);
        }
        return map == null ? defaultValue : map.get(key2, defaultValue);
    }

    public double getSure(String key1, String key2) {
        StringDoubleMap map = this.getMap(key1, false);
        if (map == null) {
            throw new RuntimeException("Missing key: " + key1);
        }
        return map.getSure(key2);
    }

    public void put(String key1, StringDoubleMap map) {
        if (this.locked) {
            throw new RuntimeException("Cannot make new entry for " + key1 + ", because map is locked");
        }
        this.maps.put(key1, map);
    }

    public void put(String key1, String key2, double value) {
        StringDoubleMap map = this.getMap(key1, true);
        map.put(key2, value);
    }

    public void incr(String key1, String key2, double dValue) {
        StringDoubleMap map = this.getMap(key1, true);
        map.incr(key2, dValue);
    }

    public void scale(String key1, String key2, double dValue) {
        StringDoubleMap map = this.getMap(key1, true);
        map.scale(key2, dValue);
    }

    public int size() {
        return this.maps.size();
    }

    public int totalSize() {
        int n = 0;
        for (StringDoubleMap map : this.maps.values()) {
            n += map.size();
        }
        return n;
    }

    public void gut() {
        for (StringDoubleMap map : this.maps.values()) {
            map.gut();
        }
    }

    @Override
    public Iterator<Map.Entry<String, StringDoubleMap>> iterator() {
        return this.maps.entrySet().iterator();
    }

    public Set<Map.Entry<String, StringDoubleMap>> entrySet() {
        return this.maps.entrySet();
    }

    public Set<String> keySet() {
        return this.maps.keySet();
    }

    public Collection<StringDoubleMap> values() {
        return this.maps.values();
    }

    public void multAll(double dValue) {
        for (StringDoubleMap map : this.maps.values()) {
            map.multAll(dValue);
        }
    }

    public String2DoubleMap copy() {
        return this.copy(this.newMap());
    }

    public String2DoubleMap copy(String2DoubleMap newMap) {
        newMap.locked = this.locked;
        for (Map.Entry<String, StringDoubleMap> e : this.maps.entrySet()) {
            newMap.maps.put(e.getKey(), e.getValue().copy());
        }
        return newMap;
    }

    public String2DoubleMap restrict(Set<String> set1, Set<String> set2) {
        return this.restrict(this.newMap(), set1, set2);
    }

    public String2DoubleMap restrict(String2DoubleMap newMap, Set<String> set1, Set<String> set2) {
        newMap.locked = this.locked;
        for (Map.Entry<String, StringDoubleMap> e : this.maps.entrySet()) {
            if (!set1.contains(e.getKey())) continue;
            newMap.maps.put(e.getKey(), e.getValue().restrict(set2));
        }
        return newMap;
    }

    public String2DoubleMap reverse(String2DoubleMap newMap) {
        for (Map.Entry<String, StringDoubleMap> e1 : this.maps.entrySet()) {
            String key1 = e1.getKey();
            StringDoubleMap map = e1.getValue();
            for (StringDoubleMap.Entry e2 : map) {
                String key2 = e2.getKey();
                double value = e2.getValue();
                newMap.put(key2, key1, value);
            }
        }
        return newMap;
    }

    public void lock() {
        for (StringDoubleMap map : this.maps.values()) {
            map.lock();
        }
    }

    public void switchToSortedList() {
        for (StringDoubleMap map : this.maps.values()) {
            map.switchToSortedList();
        }
    }

    public void switchToHashTable() {
        for (StringDoubleMap map : this.maps.values()) {
            map.switchToHashTable();
        }
    }

    protected String2DoubleMap newMap() {
        return new String2DoubleMap();
    }

    public StringDoubleMap getMap(String key1, boolean modify) {
        if (key1 == this.lastKey) {
            return this.lastMap;
        }
        StringDoubleMap map = this.maps.get(key1);
        if (map != null) {
            return map;
        }
        if (modify) {
            if (this.locked) {
                throw new RuntimeException("Cannot make new entry for " + key1 + ", because map is locked");
            }
            map = new StringDoubleMap();
            this.maps.put(key1, map);
            this.lastKey = key1;
            this.lastMap = map;
            return map;
        }
        return null;
    }
}

