/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.treeapprox;

import edu.berkeley.nlp.tokenizer.PTBTokenizer;
import edu.berkeley.nlp.util.IOUtils;
import edu.pku.coli.io.DAGSentenceReader;
import edu.pku.coli.pear.dag.DAGCombiner;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import edu.pku.coli.treeapprox.TreeApproxParser;
import edu.umd.clip.latagger.LatentTagger;
import edu.umd.clip.latagger.LatentTaggerTrainer;
import fig.basic.Option;
import fig.exec.Execution;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;

public class TrapMain
implements Runnable {
    @Option
    public String train;
    @Option(gloss="train format (CoNLL08|sdp|sdp15)")
    public String trainFormat = "CoNLL08";
    @Option(required=true, gloss="Directory of models")
    public String models;
    @Option
    public String test;
    @Option(gloss="test format (plain|CoNLL08|wordPerLine|sdp15)")
    public String testFormat = "CoNLL08";
    @Option
    public String out;
    @Option
    public boolean deleteTmpFiles = true;
    @Option
    public boolean trainTaggingModel = true;
    @Option
    public boolean modelEnsemble = true;
    public boolean withTree = false;
    public int taggerSplitNum = 6;
    public double combineThreshold = 0.5;
    private File tmpDir;
    private File modelsDir;
    private String tagModelFile;
    private String lexiconFile;
    private String[] trapModelFiles;
    private String testFile;
    private String[][] trapOptPres;
    private String[] trapAlgos;

    public void initialize() {
        this.trapOptPres = new String[5][5];
        int i = 0;
        while (i < 5) {
            this.trapOptPres[i][0] = this.trainFormat;
            this.trapOptPres[i][2] = "true";
            this.trapOptPres[i][3] = "both";
            this.trapOptPres[i][4] = "level";
            ++i;
        }
        this.trapOptPres[0][1] = "dfs";
        this.trapOptPres[1][1] = "bfs";
        this.trapOptPres[1][2] = "false";
        this.trapOptPres[2][1] = "iteration";
        this.trapOptPres[2][2] = "false";
        this.trapOptPres[3][1] = "projective";
        this.trapOptPres[4][1] = "nonprojective";
        this.trapAlgos = new String[this.trapOptPres.length];
        i = 0;
        while (i < this.trapOptPres.length) {
            this.trapAlgos[i] = this.trapOptPres[i][1];
            ++i;
        }
    }

    public static void main(String[] args) {
        if (args.length == 0 || args[0].equals("-h")) {
            TrapMain.printHelp();
            System.exit(0);
        }
        Execution.run(args, new TrapMain());
    }

    @Override
    public void run() {
        this.initialize();
        this.modelsDir = new File(this.models);
        if (this.modelsDir.isFile()) {
            throw new RuntimeException("Not a directory: " + this.models);
        }
        if (!this.modelsDir.isDirectory()) {
            this.modelsDir.mkdirs();
        }
        this.tmpDir = new File(String.valueOf(this.modelsDir.getPath()) + File.separator + "tmp" + System.currentTimeMillis());
        if (this.tmpDir.isFile()) {
            throw new RuntimeException("Tmp file name conflict: " + this.tmpDir);
        }
        if (!this.tmpDir.isDirectory()) {
            this.tmpDir.mkdir();
        } else {
            File[] fileArray = this.tmpDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                f.delete();
                ++n2;
            }
        }
        this.tagModelFile = String.valueOf(this.modelsDir.getPath()) + File.separator + "tagger.mod";
        this.lexiconFile = String.valueOf(this.modelsDir.getPath()) + File.separator + "tagger.lex";
        this.trapModelFiles = new String[this.trapOptPres.length];
        int i = 0;
        while (i < this.trapModelFiles.length) {
            this.trapModelFiles[i] = String.valueOf(this.modelsDir.getPath()) + File.separator + "trap-" + this.trapOptPres[i][1] + ".mod";
            ++i;
        }
        if (this.train != null) {
            try {
                this.train();
            }
            catch (Exception e) {
                if (this.deleteTmpFiles) {
                    this.deleteTmpFiles();
                }
                throw new RuntimeException(e);
            }
        }
        if (this.test != null) {
            if (this.out == null) {
                this.out = String.valueOf(this.test) + ".out";
            }
            try {
                this.test();
            }
            catch (Exception e) {
                if (this.deleteTmpFiles) {
                    this.deleteTmpFiles();
                }
                throw new RuntimeException(e);
            }
        }
        if (this.deleteTmpFiles) {
            this.deleteTmpFiles();
        }
    }

    private static void printHelp() {
        System.out.println("Usage: [-train <trainfile>] -models <model directory> [-test <testfile>] [-out <outfile(default=testfile+\".out\")>]\nOptional args: -trainFormat <conll08(default)|sdp> -testFormat <plain|conll08(default)|wordPerLine> -trainTaggingModel <true(default)|false> -modelEnsemble <true(default)|false> -deleteTmpFiles <true(default)|false>\nNotice: tagging model is required when testFormat is plain or wordPerLine.\n");
    }

    private void deleteTmpFiles() {
        File[] fileArray = this.tmpDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            f.delete();
            ++n2;
        }
        this.tmpDir.delete();
        System.out.println("Tmp file deleted.");
    }

    private void test() throws Exception {
        if (this.testFormat.equalsIgnoreCase("plain")) {
            String newtestwrd = String.valueOf(this.tmpDir.getPath()) + File.separator + "test.wrd";
            String newtestpos = String.valueOf(this.tmpDir.getPath()) + File.separator + "test.pos";
            PrintWriter testwrdpw = new PrintWriter(newtestwrd);
            BufferedReader testbr = IOUtils.openInEasy((String)this.test);
            String line = null;
            while ((line = testbr.readLine()) != null) {
                PTBTokenizer tokenizer = new PTBTokenizer((Reader)new StringReader(line));
                while (tokenizer.hasNext()) {
                    testwrdpw.println(tokenizer.next());
                }
                testwrdpw.println();
            }
            testbr.close();
            testwrdpw.close();
            LatentTagger.main((String[])new String[]{"-model", this.tagModelFile, "-input", newtestwrd, "-output", newtestpos});
            String newtest = String.valueOf(this.tmpDir.getPath()) + File.separator + "test";
            PrintWriter newtestpw = new PrintWriter(newtest);
            BufferedReader testwrdbr = IOUtils.openInEasy((String)newtestwrd);
            BufferedReader testposbr = IOUtils.openInEasy((String)newtestpos);
            String wrd = null;
            String pos = null;
            int index = 1;
            while ((wrd = testwrdbr.readLine()) != null) {
                pos = testposbr.readLine();
                if (wrd.isEmpty()) {
                    newtestpw.println();
                    index = 1;
                    continue;
                }
                newtestpw.print("" + index);
                newtestpw.print(" " + wrd);
                newtestpw.print(" " + wrd);
                newtestpw.print(" " + pos);
                newtestpw.print(" " + pos);
                int i = 6;
                while (i <= 11) {
                    newtestpw.print(" _");
                    ++i;
                }
                newtestpw.println();
                ++index;
            }
            testwrdbr.close();
            testposbr.close();
            newtestpw.close();
            this.testFile = newtest;
            this.testFormat = "conll08";
        } else if (this.testFormat.equalsIgnoreCase("wordperline")) {
            this.test = this.processEscape(this.test);
            String newtestpos = String.valueOf(this.tmpDir.getPath()) + File.separator + "test.pos";
            LatentTagger.main((String[])new String[]{"-model", this.tagModelFile, "-input", this.test, "-output", newtestpos});
            String newtest = String.valueOf(this.tmpDir.getPath()) + File.separator + "test";
            PrintWriter newtestpw = new PrintWriter(newtest);
            BufferedReader testwrdbr = IOUtils.openInEasy((String)this.test);
            BufferedReader testposbr = IOUtils.openInEasy((String)newtestpos);
            String wrd = null;
            String pos = null;
            int index = 1;
            while ((wrd = testwrdbr.readLine()) != null) {
                pos = testposbr.readLine();
                if (wrd.isEmpty()) {
                    newtestpw.println();
                    index = 1;
                    continue;
                }
                newtestpw.print("" + index);
                newtestpw.print(" " + wrd);
                newtestpw.print(" " + wrd);
                newtestpw.print(" " + pos);
                newtestpw.print(" " + pos);
                int i = 6;
                while (i <= 11) {
                    newtestpw.print(" _");
                    ++i;
                }
                newtestpw.println();
                ++index;
            }
            testwrdbr.close();
            testposbr.close();
            newtestpw.close();
            this.testFile = newtest;
            this.testFormat = "conll08";
        } else if (this.testFormat.equalsIgnoreCase("conll08")) {
            this.testFile = this.test;
        } else if (this.testFormat.equalsIgnoreCase("sdp")) {
            this.testFile = this.test;
        } else if (this.testFormat.equalsIgnoreCase("sdp15")) {
            this.testFile = this.test;
        } else {
            throw new IOException("Unkown format: " + this.testFormat);
        }
        if (this.modelEnsemble) {
            String[] trapTmpOutFiles = new String[this.trapOptPres.length];
            int i = 0;
            while (i < trapTmpOutFiles.length) {
                trapTmpOutFiles[i] = String.valueOf(this.tmpDir.getPath()) + File.separator + "trap-" + this.trapOptPres[i][1] + ".tmp.out";
                ++i;
            }
            i = 0;
            while (i < this.trapOptPres.length) {
                ArrayList<String> args = new ArrayList<String>();
                args.add(this.testFormat);
                int j = 1;
                while (j < this.trapOptPres[i].length) {
                    args.add(this.trapOptPres[i][j]);
                    ++j;
                }
                args.add("-test");
                args.add(this.testFile);
                args.add("-out");
                args.add(trapTmpOutFiles[i]);
                args.add("-model");
                args.add(this.trapModelFiles[i]);
                TreeApproxParser.main(args.toArray(new String[0]));
                ++i;
            }
            DAGCombiner c = new DAGCombiner();
            c.in = this.tmpDir.getPath();
            c.out = this.out;
            c.threshold = this.combineThreshold;
            c.format = this.testFormat;
            c.suffix = ".tmp.out";
            c.gold = this.testFile;
            c.run();
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.testFormat);
            int j = 1;
            while (j < this.trapOptPres[0].length) {
                args.add(this.trapOptPres[0][j]);
                ++j;
            }
            args.add("-test");
            args.add(this.testFile);
            args.add("-out");
            args.add(this.out);
            args.add("-model");
            args.add(this.trapModelFiles[0]);
            TreeApproxParser.main(args.toArray(new String[0]));
        }
    }

    private String processEscape(String test) throws IOException {
        String line;
        String newtestwrd = String.valueOf(this.tmpDir.getPath()) + File.separator + "test.wrd";
        PrintWriter testwrdpw = new PrintWriter(newtestwrd);
        BufferedReader testwrdbr = IOUtils.openInEasy((String)test);
        while ((line = testwrdbr.readLine()) != null) {
            String w = SentenceForDAGParsing.toEscapedBracket(line, false);
            if (w != line) {
                line = w;
                SentenceForDAGParsing.escapedWordBracket = true;
            }
            testwrdpw.println(line);
        }
        testwrdpw.close();
        return newtestwrd;
    }

    private void train() throws Exception {
        DAGSentenceReader reader = null;
        if (this.trainFormat.equalsIgnoreCase("conll08")) {
            reader = DAGSentenceReader.dagsReaderFromCoNLL08(this.train, this.withTree);
        } else if (this.trainFormat.equalsIgnoreCase("sdp")) {
            reader = DAGSentenceReader.dagsReaderFromSDP(this.train);
        } else if (this.trainFormat.equalsIgnoreCase("sdp15")) {
            reader = DAGSentenceReader.dagsReaderFromSDP15(this.train);
        } else {
            throw new IOException("Unsupported train format: " + this.trainFormat + "!");
        }
        if (this.trainTaggingModel) {
            String wrdpos = String.valueOf(this.tmpDir.getPath()) + File.separator + "trn.pos";
            PrintWriter wppw = new PrintWriter(wrdpos);
            for (SentenceForDAGParsing s : reader) {
                int i = 0;
                while (i < s.words().length) {
                    wppw.println(String.valueOf(s.words()[i]) + '\t' + s.tags()[i]);
                    ++i;
                }
                wppw.println();
            }
            wppw.close();
            LatentTaggerTrainer.main((String[])new String[]{"-train", wrdpos, "-model", this.tagModelFile, "-lex", this.lexiconFile});
            File tagModel = new File(this.tagModelFile);
            if (tagModel.exists()) {
                tagModel.delete();
            }
            File tagModelMaxIter = new File(String.valueOf(this.tagModelFile) + "-" + this.taggerSplitNum + "-smoothing.model");
            tagModelMaxIter.renameTo(tagModel);
            File tmpMod = new File(String.valueOf(this.tagModelFile) + "-0.model");
            tmpMod.delete();
            int i = 1;
            while (i <= this.taggerSplitNum) {
                tmpMod = new File(String.valueOf(this.tagModelFile) + "-" + i + "-splitting.model");
                tmpMod.delete();
                tmpMod = new File(String.valueOf(this.tagModelFile) + "-" + i + "-merging.model");
                tmpMod.delete();
                tmpMod = new File(String.valueOf(this.tagModelFile) + "-" + i + "-smoothing.model");
                tmpMod.delete();
                ++i;
            }
        }
        if (this.modelEnsemble) {
            int i = 0;
            while (i < this.trapOptPres.length) {
                ArrayList<String> args = new ArrayList<String>();
                int j = 0;
                while (j < this.trapOptPres[i].length) {
                    args.add(this.trapOptPres[i][j]);
                    ++j;
                }
                args.add("-train");
                args.add(this.train);
                args.add("-model");
                args.add(this.trapModelFiles[i]);
                TreeApproxParser.main(args.toArray(new String[0]));
                ++i;
            }
        } else {
            ArrayList<String> args = new ArrayList<String>();
            args.add("-train");
            int j = 0;
            while (j < this.trapOptPres[0].length) {
                args.add(this.trapOptPres[0][j]);
                ++j;
            }
            args.add("-train");
            args.add(this.train);
            args.add("-model");
            args.add(this.trapModelFiles[0]);
            TreeApproxParser.main(args.toArray(new String[0]));
        }
    }
}

