/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.dualdecomp;

import edu.pku.coli.dualdecomp.AbstractDecoder;
import edu.pku.coli.pear.dag.PredicateArgumentAdjunctDAG;
import edu.pku.coli.pear.dag.SentenceForDAGParsing;
import fig.basic.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class ArcClassificationDecoder
extends AbstractDecoder {
    private static final long serialVersionUID = 7136701440981542072L;
    transient double[][] scores;

    public ArcClassificationDecoder() {
        this.featureExtractor = new FeatureExtractor();
    }

    @Override
    public SentenceForDAGParsing toDAGSentence(SentenceForDAGParsing sent, int[][] var) {
        int sentLen = sent.numOfWords();
        PredicateArgumentAdjunctDAG sys = new PredicateArgumentAdjunctDAG(sentLen);
        int i = 0;
        while (i <= sentLen) {
            int j = 0;
            while (j <= sentLen) {
                if (var[i][j] == 1) {
                    sys.addArc(i, j, "X");
                }
                ++j;
            }
            ++i;
        }
        sent.setPredictedDAG(sys);
        return sent;
    }

    @Override
    public int[][] toVariable(SentenceForDAGParsing sent) {
        int sentLen = sent.numOfWords();
        int[][] var = new int[sentLen + 1][sentLen + 1];
        PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
        for (Pair<Integer, Integer> arc : dag.toUnlabeledPairs()) {
            var[arc.getFirst().intValue()][arc.getSecond().intValue()] = 1;
        }
        return var;
    }

    @Override
    public int[][] decodeAfterScoring(double[][] additionalWeight) {
        SentenceForDAGParsing sent = this.curSent;
        int sentLen = sent.numOfWords();
        double totalScore = 0.0;
        int[][] var = new int[sentLen + 1][sentLen + 1];
        int i = 0;
        while (i <= sentLen) {
            int j = 0;
            while (j <= sentLen) {
                if (this.scores[i][j] + additionalWeight[i][j] > 0.0) {
                    totalScore += this.scores[i][j] + additionalWeight[i][j];
                    var[i][j] = 1;
                }
                ++j;
            }
            ++i;
        }
        return var;
    }

    @Override
    void scoreFeats(final float[] params) {
        int j;
        final SentenceForDAGParsing sent = this.curSent;
        final FeatureExtractor fe = (FeatureExtractor)this.featureExtractor;
        int sentLen = sent.numOfWords();
        this.scores = new double[sentLen + 1][sentLen + 1];
        ExecutorService es = Executors.newFixedThreadPool(this.threadNum);
        ExecutorCompletionService<Double> group = new ExecutorCompletionService<Double>(es);
        Future[][] results = new Future[sentLen + 1][sentLen + 1];
        int i = 0;
        while (i <= sentLen) {
            j = 1;
            while (j <= sentLen) {
                final int fi = i;
                final int fj = j;
                results[i][j] = group.submit(new Callable<Double>(){

                    @Override
                    public Double call() throws Exception {
                        return fe.scoreArcFeats(fi, fj, sent, params);
                    }
                });
                ++j;
            }
            ++i;
        }
        es.shutdown();
        i = 0;
        while (i <= sentLen) {
            j = 1;
            while (j <= sentLen) {
                try {
                    this.scores[i][j] = (Double)results[i][j].get();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
                ++j;
            }
            ++i;
        }
    }

    class FeatureExtractor
    extends AbstractDecoder.FeatureExtractor {
        private static final long serialVersionUID = 3305863181727616401L;

        FeatureExtractor() {
        }

        @Override
        List<Integer> extract(SentenceForDAGParsing sent, boolean predicted) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int sentLen = sent.numOfWords();
            PredicateArgumentAdjunctDAG dag = sent.getGoldDAG();
            if (predicted) {
                dag = sent.getPredictedDAG();
            }
            for (Pair<Integer, Integer> arc : dag.toUnlabeledPairs()) {
                ret.addAll(this.arcFeats(arc.getFirst(), arc.getSecond(), sent));
            }
            return ret;
        }

        public Double scoreArcFeats(int head, int dependent, SentenceForDAGParsing sent, float[] params) {
            return ArcClassificationDecoder.this.score(this.arcFeats(head, dependent, sent), params);
        }

        private List<Integer> arcFeats(int head, int dependent, SentenceForDAGParsing sent) {
            ArrayList<Integer> ret = new ArrayList<Integer>();
            int n = 1024;
            int headWord = sent.getKthWordIndex(head);
            int headPos = sent.getKthWordIndex(head);
            int preHeadWord = sent.getKthWordIndex(head - 1);
            int postHeadord = sent.getKthWordIndex(head + 1);
            int preHeadPos = sent.getKthPosIndex(head - 1);
            int postHeadPos = sent.getKthPosIndex(head + 1);
            int curWord = sent.getKthWordIndex(dependent);
            int curPos = sent.getKthPosIndex(dependent);
            int preCurWord = sent.getKthWordIndex(dependent - 1);
            int postCurWord = sent.getKthWordIndex(dependent + 1);
            int preCurPos = sent.getKthPosIndex(dependent - 1);
            int postCurPos = sent.getKthPosIndex(dependent + 1);
            int distCur = ArcClassificationDecoder.this.distMap(head - dependent);
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, preHeadWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, preHeadWord, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, preCurWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, preCurWord, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, postHeadord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, postHeadord, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, postCurWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, postCurWord, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preHeadWord, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, postHeadord, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postHeadord, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, preCurWord, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, preCurWord, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, postCurWord, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, postCurWord, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, preHeadWord, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, preHeadWord, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, preHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, postHeadord, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curWord, curPos, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, postHeadord, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, curPos, postHeadPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preCurWord, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postCurWord, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postCurPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, preCurWord, preCurPos, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preCurWord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preCurWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preCurPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preCurPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preCurWord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preCurWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preCurPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preCurPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, postCurWord, postCurPos, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postCurWord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postCurWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postCurPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postCurPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postCurWord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postCurWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postCurPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postCurPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, preHeadWord, preHeadPos, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preHeadWord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preHeadWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preHeadPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, preHeadPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preHeadWord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preHeadWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preHeadPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, preHeadPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, headPos, postHeadord, postHeadPos, curWord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postHeadord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postHeadord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postHeadPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headWord, postHeadPos, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postHeadord, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postHeadord, curPos, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postHeadPos, curWord, distCur));
            ret.add(ArcClassificationDecoder.this.hashInts(n++, headPos, postHeadPos, curPos, distCur));
            PredicateArgumentAdjunctDAG tree = sent.getSyntaxTree();
            if (ArcClassificationDecoder.this.usePathFeat && tree != null && !tree.isEmpty() && dependent <= sent.numOfWords()) {
                char p;
                int pos;
                PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                ArrayList<Integer> headToRoot = new ArrayList<Integer>();
                int t = dependent;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    curToRoot.add(t);
                    t = parentArc.index;
                }
                curToRoot.add(t);
                t = head;
                while ((parentArc = tree.getOneParent(t)) != null) {
                    headToRoot.add(t);
                    t = parentArc.index;
                }
                headToRoot.add(t);
                int leastCommonAncestor = 1;
                while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= headToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == headToRoot.get(headToRoot.size() - leastCommonAncestor)) {
                    ++leastCommonAncestor;
                }
                int pathPoss = n++;
                int pathP = n++;
                int i = 0;
                while (i <= curToRoot.size() - leastCommonAncestor) {
                    pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                    p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    ++i;
                }
                pathPoss = -pathPoss;
                pathP = -pathP;
                if (leastCommonAncestor > 1) {
                    int pos2 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                    char p2 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                    pathPoss = 31 * pathPoss + pos2;
                    pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                    pathP = 31 * pathP + p2;
                    pathP = 31 * pathP + 255;
                }
                i = headToRoot.size() - leastCommonAncestor;
                while (i >= 0) {
                    pos = sent.getKthPosIndex((Integer)headToRoot.get(i));
                    p = sent.getKthPos((Integer)headToRoot.get(i)).charAt(0);
                    pathPoss = 31 * pathPoss + pos;
                    pathP = 31 * pathP + p;
                    --i;
                }
                ret.add(ArcClassificationDecoder.this.hashInts(pathPoss));
                ret.add(ArcClassificationDecoder.this.hashInts(pathP));
                ret.add(ArcClassificationDecoder.this.hashInts(pathPoss, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(pathP, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, curWord, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headPos, curWord, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, curWord, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headPos, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, headPos, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, curWord, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headPos, curWord, curPos, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, curWord, distCur));
                ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headPos, curPos, distCur));
            }
            if (sent.getMoreSyntaxTrees() != null && dependent <= sent.numOfWords()) {
                for (PredicateArgumentAdjunctDAG mtree : sent.getMoreSyntaxTrees()) {
                    char p;
                    int pos;
                    PredicateArgumentAdjunctDAG.ArcInfo parentArc;
                    ArrayList<Integer> curToRoot = new ArrayList<Integer>();
                    ArrayList<Integer> headToRoot = new ArrayList<Integer>();
                    ArrayList<String> stkTopToRootLabels = new ArrayList<String>();
                    ArrayList<String> queTopToRootLabels = new ArrayList<String>();
                    int t = dependent;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        curToRoot.add(t);
                        stkTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    curToRoot.add(t);
                    t = head;
                    while ((parentArc = mtree.getOneParent(t)) != null) {
                        headToRoot.add(t);
                        queTopToRootLabels.add(parentArc.label);
                        t = parentArc.index;
                    }
                    headToRoot.add(t);
                    int leastCommonAncestor = 1;
                    while (leastCommonAncestor <= curToRoot.size() && leastCommonAncestor <= headToRoot.size() && curToRoot.get(curToRoot.size() - leastCommonAncestor) == headToRoot.get(headToRoot.size() - leastCommonAncestor)) {
                        ++leastCommonAncestor;
                    }
                    int pathPoss = n++;
                    int pathP = n++;
                    int pathLab = n++;
                    int i = 0;
                    while (i <= curToRoot.size() - leastCommonAncestor) {
                        pos = sent.getKthPosIndex((Integer)curToRoot.get(i));
                        p = sent.getKthPos((Integer)curToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)stkTopToRootLabels.get(i)).hashCode();
                        ++i;
                    }
                    pathPoss = -pathPoss;
                    pathP = -pathP;
                    pathLab = -pathLab;
                    if (leastCommonAncestor > 1) {
                        int pos3 = sent.getKthPosIndex((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1));
                        char p3 = sent.getKthPos((Integer)curToRoot.get(curToRoot.size() - leastCommonAncestor + 1)).charAt(0);
                        pathPoss = 31 * pathPoss + pos3;
                        pathPoss = 31 * pathPoss + SentenceForDAGParsing.posIndexer.size();
                        pathP = 31 * pathP + p3;
                        pathP = 31 * pathP + 255;
                    }
                    i = headToRoot.size() - leastCommonAncestor;
                    while (i >= 0) {
                        pos = sent.getKthPosIndex((Integer)headToRoot.get(i));
                        p = sent.getKthPos((Integer)headToRoot.get(i)).charAt(0);
                        pathPoss = 31 * pathPoss + pos;
                        pathP = 31 * pathP + p;
                        pathLab = 31 * pathLab + ((String)queTopToRootLabels.get(i)).hashCode();
                        --i;
                    }
                    ret.add(ArcClassificationDecoder.this.hashInts(pathPoss));
                    ret.add(ArcClassificationDecoder.this.hashInts(pathP));
                    ret.add(ArcClassificationDecoder.this.hashInts(pathLab));
                    ret.add(ArcClassificationDecoder.this.hashInts(pathPoss, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(pathP, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(pathLab, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curWord, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, headPos, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headPos, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headWord, curWord, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathPoss, headPos, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, headPos, curWord, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, headPos, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headPos, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headWord, curWord, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathP, headPos, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathLab, headWord, headPos, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathLab, headWord, headPos, curWord, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathLab, headWord, headPos, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathLab, headWord, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathLab, headPos, curWord, curPos, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathLab, headWord, curWord, distCur));
                    ret.add(ArcClassificationDecoder.this.hashInts(n++, pathLab, headPos, curPos, distCur));
                }
            }
            return ret;
        }
    }
}

