/*
 * Decompiled with CFR 0.152.
 */
package fig.basic;

import fig.basic.IOUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractLispTree<TreeType extends AbstractLispTree> {
    public String value;
    public List<TreeType> children;
    private static final int defaultMaxWidth = 180;

    public boolean isLeaf() {
        return this.children == null;
    }

    public TreeType child(int i) {
        return (TreeType)((AbstractLispTree)this.children.get(i));
    }

    public void addChild(TreeType tree) {
        this.children.add(tree);
    }

    public void addChild(String value) {
        this.addChild(this.newLeaf(value));
    }

    public int numLeaves() {
        if (this.isLeaf()) {
            return 1;
        }
        int n = 0;
        for (AbstractLispTree arg : this.children) {
            n += arg.numLeaves();
        }
        return n;
    }

    public int numNodes() {
        if (this.isLeaf()) {
            return 1;
        }
        int n = 1;
        for (AbstractLispTree arg : this.children) {
            n += arg.numNodes();
        }
        return n;
    }

    public TreeType head() {
        return this.child(0);
    }

    public TreeType tail() {
        TreeType result = this.newTree();
        ((AbstractLispTree)result).children = this.children.subList(1, this.children.size());
        return result;
    }

    public TreeType cons(TreeType tail) {
        AbstractLispTree result = this.newList();
        result.addChild((AbstractLispTree)this);
        for (AbstractLispTree x : ((AbstractLispTree)tail).children) {
            result.addChild((AbstractLispTree)x);
        }
        return (TreeType)result;
    }

    protected abstract TreeType newTree();

    public TreeType newLeaf(String value) {
        if (value == null) {
            throw new RuntimeException("Null value");
        }
        TreeType tree = this.newTree();
        ((AbstractLispTree)tree).value = value;
        return tree;
    }

    public TreeType newList() {
        TreeType tree = this.newTree();
        ((AbstractLispTree)tree).children = new ArrayList<TreeType>();
        return tree;
    }

    public TreeType newList(List<String> items) {
        TreeType tree = this.newList();
        for (String x : items) {
            ((AbstractLispTree)tree).addChild(x);
        }
        return tree;
    }

    public TreeType newList(String t1, String t2) {
        TreeType tree = this.newList();
        ((AbstractLispTree)tree).addChild(t1);
        ((AbstractLispTree)tree).addChild(t2);
        return tree;
    }

    public TreeType newList(String t1, TreeType t2) {
        TreeType tree = this.newList();
        ((AbstractLispTree)tree).addChild(t1);
        ((AbstractLispTree)tree).addChild(t2);
        return tree;
    }

    public TreeType newList(TreeType t1, String t2) {
        TreeType tree = this.newList();
        ((AbstractLispTree)tree).addChild(t1);
        ((AbstractLispTree)tree).addChild(t2);
        return tree;
    }

    public TreeType newList(TreeType t1, TreeType t2) {
        TreeType tree = this.newList();
        ((AbstractLispTree)tree).addChild(t1);
        ((AbstractLispTree)tree).addChild(t2);
        return tree;
    }

    public TreeType convert(AbstractLispTree tree) {
        if (tree.isLeaf()) {
            return this.newLeaf(tree.value);
        }
        TreeType result = this.newList();
        for (AbstractLispTree child : tree.children) {
            ((AbstractLispTree)result).addChild(this.convert(child));
        }
        return result;
    }

    public Iterator<TreeType> parseFromFile(String path) {
        try {
            BufferedReader in = IOUtils.openIn(path);
            return new ParseLispTreeIterator<AbstractLispTree>(in, this);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public TreeType parseFromString(String str) {
        BufferedReader in = new BufferedReader(new StringReader(str));
        ParseLispTreeIterator<AbstractLispTree> it = new ParseLispTreeIterator<AbstractLispTree>(in, this);
        if (!it.hasNext()) {
            throw new RuntimeException("Invalid: " + str);
        }
        return (TreeType)((AbstractLispTree)it.next());
    }

    public String toString() {
        return this.toStringWrap(Integer.MAX_VALUE);
    }

    public String toStringWrap() {
        return this.toStringWrap(180);
    }

    public String toStringWrap(int maxWidth) {
        return this.toStringWrap(maxWidth, maxWidth);
    }

    public String toStringWrap(int maxWidth, int subMaxWidth) {
        StringWriter out = new StringWriter();
        this.print(maxWidth, subMaxWidth, out);
        return out.toString();
    }

    public void print(Writer out) {
        this.print(180, 180, out);
    }

    public void print(int maxWidth, int subMaxWidth, Writer out) {
        try {
            this.toStringHelper(maxWidth, subMaxWidth, "", out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int numChars(int maxWidth) {
        if (this.isLeaf()) {
            return this.value.length();
        }
        int sum = 1 + this.children.size();
        for (AbstractLispTree child : this.children) {
            if ((sum += child.numChars(maxWidth - sum)) <= maxWidth) continue;
            return sum;
        }
        return sum;
    }

    protected void toStringHelper(int maxWidth, int subMaxWidth, String indent, Writer out) throws IOException {
        if (this.isLeaf()) {
            out.append(indent);
            if (this.value == null) {
                out.append("\"\"");
            } else {
                char c;
                boolean shouldQuote = this.value.length() == 0;
                int i = 0;
                while (i < this.value.length()) {
                    c = this.value.charAt(i);
                    if (Character.isWhitespace(c) || c == '(' || c == ')' || c == '#') {
                        shouldQuote = true;
                        break;
                    }
                    ++i;
                }
                if (shouldQuote) {
                    out.append('\"');
                }
                i = 0;
                while (i < this.value.length()) {
                    c = this.value.charAt(i);
                    if (c == '\"' || c == '\\') {
                        out.append('\\');
                        out.append(c);
                    } else if (c == '\n') {
                        out.append('\\');
                        out.append('n');
                    } else if (c == '\t') {
                        out.append('\\');
                        out.append('t');
                    } else {
                        out.append(c);
                    }
                    ++i;
                }
                if (shouldQuote) {
                    out.append('\"');
                }
            }
        } else if (this.numChars(maxWidth) <= maxWidth) {
            out.append(indent);
            boolean first = true;
            out.append('(');
            for (AbstractLispTree subtree : this.children) {
                if (!first) {
                    out.append(' ');
                }
                subtree.toStringHelper(Integer.MAX_VALUE, Integer.MAX_VALUE, "", out);
                first = false;
            }
            out.append(')');
        } else {
            out.append(indent);
            out.append('(');
            boolean first = true;
            String newIndent = String.valueOf(indent) + "  ";
            for (AbstractLispTree subtree : this.children) {
                if (first && subtree.isLeaf()) {
                    subtree.toStringHelper(Integer.MAX_VALUE, Integer.MAX_VALUE, "", out);
                } else {
                    out.append('\n');
                    subtree.toStringHelper(subMaxWidth, subMaxWidth, newIndent, out);
                }
                first = false;
            }
            out.append('\n');
            out.append(indent);
            out.append(')');
        }
    }

    static class ParseLispTreeIterator<TreeType extends AbstractLispTree>
    implements Iterator<TreeType> {
        private TreeType proto;
        private BufferedReader reader;
        private int start_line_num = -1;
        private int start_i = -1;
        private int line_num = 0;
        private String line = null;
        private int i = -1;
        private int n = 0;
        private char c = '\u0000';

        public ParseLispTreeIterator(BufferedReader reader, TreeType proto) {
            this.reader = reader;
            this.proto = proto;
            this.advance();
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            this.skipSpace();
            return this.c != '\u0000';
        }

        @Override
        public TreeType next() {
            this.start_line_num = this.line_num;
            this.start_i = this.i;
            return this.recurse();
        }

        private void error(String msg) {
            throw new RuntimeException(String.format("%s from %s:%s to %s:%s", msg, this.start_line_num, this.start_i, this.line_num, this.i));
        }

        private void advance() {
            ++this.i;
            while (this.i == this.n) {
                try {
                    this.line = this.reader.readLine();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                if (this.line == null) {
                    this.n = 0;
                    this.i = 0;
                    break;
                }
                this.line = String.valueOf(this.line) + "\n";
                ++this.line_num;
                this.n = this.line.length();
                this.i = 0;
            }
            this.c = this.line == null ? (char)'\u0000' : this.line.charAt(this.i);
        }

        private void skipSpace() {
            while (this.c != '\u0000') {
                if (this.c == '#') {
                    while (this.c != '\u0000' && this.c != '\n') {
                        this.advance();
                    }
                    continue;
                }
                if (!Character.isWhitespace(this.c)) break;
                this.advance();
            }
        }

        private TreeType recurse() {
            this.skipSpace();
            if (this.c == '\u0000') {
                return null;
            }
            if (this.c == '(') {
                this.advance();
                TreeType tree = ((AbstractLispTree)this.proto).newList();
                while (true) {
                    this.skipSpace();
                    if (this.c == '\u0000') {
                        this.error("Missing ')'");
                    } else if (this.c == ')') break;
                    ((AbstractLispTree)tree).addChild(this.recurse());
                }
                this.advance();
                return tree;
            }
            if (this.c == ')') {
                this.error("Extra ')'");
            }
            boolean escaped = false;
            boolean in_quote = false;
            StringBuilder value = new StringBuilder();
            while (this.c != '\u0000') {
                if (escaped) {
                    if (this.c == 'n') {
                        value.append('\n');
                    } else if (this.c == 't') {
                        value.append('\t');
                    } else {
                        value.append(this.c);
                    }
                    escaped = false;
                } else if (this.c == '\\') {
                    escaped = true;
                } else if (this.c == '\"') {
                    in_quote = !in_quote;
                } else {
                    if (!in_quote && (Character.isWhitespace(this.c) || this.c == ')')) break;
                    value.append(this.c);
                }
                this.advance();
            }
            if (escaped) {
                this.error("Missing escaped character");
            }
            if (in_quote) {
                this.error("Missing end quote");
            }
            return ((AbstractLispTree)this.proto).newLeaf(value.toString());
        }
    }
}

