/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import SyntaxUtils.CCGBinaryRule;
import SyntaxUtils.CCGUnaryRule;

public class Action {
    final ActionType _type;
    final CCGUnaryRule _uRule;
    final CCGBinaryRule _bRule;
    final String _tag;

    private Action(ActionType type, CCGUnaryRule u, CCGBinaryRule b, String tag) {
        this._type = type;
        this._uRule = u;
        this._tag = tag;
        this._bRule = b;
    }

    public static Action getShiftAction(String tag) {
        return new Action(ActionType.SHIFT, null, null, tag);
    }

    public static Action getUnaryAction(CCGUnaryRule uRule) {
        return new Action(ActionType.UNARY, uRule, null, null);
    }

    public static Action getReduceAction(CCGBinaryRule bRule) {
        return new Action(ActionType.REDUCE, null, bRule, null);
    }

    public boolean isShiftAction() {
        return this._type == ActionType.SHIFT;
    }

    public boolean isUnaryReduceAction() {
        return this._type == ActionType.UNARY;
    }

    public boolean isBinaryReduceAction() {
        return this._type == ActionType.REDUCE;
    }

    public String toString() {
        switch (this._type) {
            case SHIFT: {
                return String.valueOf(this._type.toString()) + ":" + this._tag;
            }
            case REDUCE: {
                return String.valueOf(this._type.toString()) + ": " + this._bRule;
            }
            case UNARY: {
                return String.valueOf(this._type.toString()) + ": " + this._uRule;
            }
        }
        return "Finish";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof Action)) {
            return false;
        }
        Action another = (Action)o;
        if (another._type != this._type) {
            return false;
        }
        switch (this._type) {
            case SHIFT: {
                String tag1 = this._tag.replaceAll("_[0-9]+", "");
                String tag2 = another._tag.replaceAll("_[0-9]+", "");
                tag1 = tag1.replaceAll("\\{[_*A-Z]+\\}", "");
                tag2 = tag2.replaceAll("\\{[_*A-Z]+\\}", "");
                tag1 = tag1.replaceAll("<[0-9]+>", "");
                tag2 = tag2.replaceAll("<[0-9]+>", "");
                return tag1.equals(tag2);
            }
            case REDUCE: {
                return this._bRule.equals(another._bRule);
            }
            case UNARY: {
                return this._uRule.equals(another._uRule);
            }
        }
        return true;
    }

    private static enum ActionType {
        SHIFT,
        REDUCE,
        UNARY;

    }
}

