###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


use Getopt::Std;

getopts('c:lfr:');
if (defined($opt_c)) {
  $mincount = $opt_c;
}else{
  $mincount = 0.0;
}
if (defined($opt_l)) {
  $longout = $opt_l;
}else{
  $longout = 0;
}
if (defined($opt_f)) {
  $rawfreq = $opt_f;
}else{
  $rawfreq = 0;
}
if (defined($opt_r)) { # don't do blind cutoffs; replace w/ symb
  $replace = $opt_r;
  $newcutoff = 1;
}else{
  $newcutoff = 0;
}

print stderr "mincount = $mincount\n";

# for the replace version
sub replace {
#    @args = @_;
#    $lowct = $args[0];
	
    # get the substitute string ready
#    @parts = split(/[ :;\{\}\/~\(\)\<\>\[\]]+/,$lowct);
#    @delims = $lowct =~ /([ :;\{\}\/~\(\)\<\>\[\]]+)/g;
#    @replacers = ( ($replace) x ($#parts+1));
#    @combined = map { $replacers[$_], $delims[$_] } 
#    0 .. ($#replacers > $#delims ? $#replacers : $#delims);
#    $r = join("",@combined);
#    return $r;
    return $replace;
}

$MapLHS{"MdL"} = ["-","L","C","E"];
$MapRHS{"MdL"} = ["L","C","L","C"];
$MapLHS{"MdR"} = ["-","L","C","E"];
$MapRHS{"MdR"} = ["L","C","L","C"];
$MapLHS{"L"} = ["L","E"];
$MapRHS{"L"} = ["E"];
$MapLHS{"Gr"} = ["-"];
$MapRHS{"Gr"} = ["L","C","E"];
$MapLHS{"G"} = ["-"];
$MapRHS{"G"} = ["-","-","L","C","E"];
$MapLHS{"P"} = [""];
$MapRHS{"P"} = ["P"];
$MapLHS{"Pc"} = ["C"];
$MapRHS{"Pc"} = ["P"];
$MapLHS{"Pw"} = ["-"];   # don't worry if a word is too infrequent
$MapRHS{"Pw"} = ["P"];
$MapLHS{"W"} = ["-"];
$MapRHS{"W"} = ["-"];
$MapLHS{"LC"} = ["-"];
$MapRHS{"LC"} = ["L","C"];   # don't use this C model; will use rhs rules
$MapLHS{"HW"} = ["-"];
$MapRHS{"HW"} = ["-"];   # don't use this HW model
$MapLHS{"+MdL"} = ["-","L","C","E"];
$MapRHS{"+MdL"} = ["L","C","L","C"];
$MapLHS{"+MdR"} = ["-","L","C","E"];
$MapRHS{"+MdR"} = ["L","C","L","C"];
$MapLHS{"+L"} = ["L","E"];
$MapRHS{"+L"} = ["E"];
$MapLHS{"+Gr"} = ["-"];
$MapRHS{"+Gr"} = ["L","C","E"];
$MapLHS{"+G"} = ["-"];
$MapRHS{"+G"} = ["-","-","L","C","E"];
$MapLHS{"+P"} = [""];
$MapRHS{"+P"} = ["P"];
$MapLHS{"+Pc"} = ["C"];
$MapRHS{"+Pc"} = ["P"];
$MapLHS{"+Pw"} = ["-"];   # don't worry if a word is too infrequent
$MapRHS{"+Pw"} = ["P"];
$MapLHS{"+W"} = ["-"];
$MapRHS{"+W"} = ["-"];
$MapLHS{"+LC"} = ["-"];
$MapRHS{"+LC"} = ["L","C"];   # don't use this C model; will use rhs rules
$MapLHS{"+HW"} = ["-"];
$MapRHS{"+HW"} = ["-"];   # don't use this HW model


while ( <> ) {
  chomp;
    
  # any model, w/ '=' sign
#  if ( $_ =~ /(.*) : (.*) = (.*)/ ){
#    if (!exists($Cond{$1})){
#      $Cond{$1} = 0.0;
#    }
#    if (!exists($Genv{$2})){
#      $Genv{$2} = 0.0;
#    }
#    if (!exists($Val{""}{$1}{$2})){
#      $Val{""}{$1}{$2} = 0.0;
#    }
#    $Cond{$1} += $3;
#    @targs = split(/ +/,$2);
#    foreach $t (@targs) {
#	$Genv{$t} += $3;
#    }
#    $Val{""}{$1}{$2} += $3;
#  } 
#  else
  # M model
  if ( $_ =~ /^(\+?M[^ ]*) (.*){(.*)} : ([^ ]*):([^ ]*) ([^ ]*):([^=]*)( = (.*))?$/ ) {
    my $add = defined($9) ? $9 : 1;
    $Cond{"$1 $2\{$3\}"}+=$add;
    $RHSVar{"L"}{$4}+=$add; $RHSVar{"L"}{$6}+=$add;    
    $RHSVar{"C"}{$5}+=$add; $RHSVar{"C"}{$7}+=$add;
    $Val{$1}{"$2\{$3\}"}{"$4:$5 $6:$7"}+=$add;
    #print" found $1 $2\{$3\} : $4:$5 $6:$7\n";
  }
  # L model
  elsif ( $_ =~ /^(\+?L[^ ]*) ([^ ]*) ([^ ]*) : ([^=]*)( = (.*))?$/ ) {
    my $add = defined($6) ? $6 : 1;
    $Cond{"$1 $2 $3"}+=$add;
    $RHSVar{"E"}{$4}+=$add;
    $Val{"$1"}{"$2 $3"}{$4}+=$add;
    #print" found $1 $2 $3 : $4\n";
  }
  # Gr Model
  elsif ( $_ =~ /^(\+?Gr) : (.*):(.*)\{(.*)\}( = (.*))?$/ ) {
    my $add = defined($6) ? $6 : 1;
    $Cond{"$1"}+=$add;
    $RHSVar{"L"}{$2}+=$add;
    $RHSVar{"C"}{$3}+=$add;
    $RHSVar{"E"}{$4}+=$add;
    $Val{"$1"}{""}{"$2:$3\{$4\}"}+=$add;
    #print" found $1 : $2:$3\{$4\}\n";
  }
  # G Model
  elsif ( $_ =~ /^(\+?G) : (.*):(.*)\{(.*)\}( = (.*))?$/ ) {
    my $add = defined($6) ? $6 : 1;
    $Cond{"$1"}+=$add;
#    $RHSVar{"L"}{$2}+=$add;
#    $RHSVar{"C"}{$3}+=$add;
#    $RHSVar{"E"}{$4}+=$add;
    $Val{"$1"}{""}{"$2:$3\{$4\}"}+=$add;
    #print" found $1 : $2:$3\{$4\}\n";
  }
  # LC Model
  elsif ( $_ =~ /^(\+?LC) : (.*):([^=]*)( = (.*))?$/ ) {
    my $add = defined($5) ? $5 : 1;
    $Cond{"$1"}+=$add;
    $RHSVar{"L"}{$2}+=$add;
    $RHSVar{"C"}{$3}+=$add;
    $Val{"$1"}{""}{"$2:$3"}+=$add;
    #print" found $1 : $2:$3\{$4\}\n";
  }
  # P Model
  elsif ( $_ =~ /^(\+?P) : ([^=]*)( = (.*))?$/ ) {
    my $add = defined($4) ? $4 : 1;
    $Cond{"$1"}+=$add;
    $RHSVar{"P"}{$2}+=$add;
    $Val{"$1"}{""}{$2}+=$add;
    #print" found $1 : $2\n";
  }
  # Pc Model
  elsif ( $_ =~ /^(\+?Pc) (.*) : ([^=]*)( = (.*))?$/ ) {
    my $add = defined($5) ? $5 : 1;
    $Cond{"$1 $2"}+=$add;
    #$RHSVar{"P"}{$3}+=$add;    # taken care of by P Model
    $Val{"$1"}{"$2"}{$3}+=$add;
    #print" found $1 $2 : $3\n";
  } 
  # Pw Model
  elsif ( $_ =~ /^(\+?Pw) (.*) : ([^=]*)( = (.*))?$/ ) {
    my $add = defined($5) ? $5 : 1;
    $Cond{"$1 $2"}+=$add;
    #$RHSVar{"P"}{$3}+=$add;    # taken care of by P Model
    $Val{"$1"}{"$2"}{$3}+=$add;
    #print" found $1 $2 : $3\n";
  } 
  # W Model
  elsif ( $_ =~ /^(\+?W) : ([^=]*)( = (.*))?$/ ) {
    my $add = defined($4) ? $4 : 1;
    $Cond{"$1"}+=$add;
    $RHSVar{"-"}{$2}+=$add;     # don't use this W model
    $Val{"$1"}{""}{$2}+=$add;
    #print" found $1 : $2\n"
  } 
#  # C Model
#  elsif ( $_ =~ /^(\+?C) : ([^=]*)( = (.*))?$/ ) {
#    my $add = defined($4) ? $4 : 1;
#    $Cond{"$1"}+=$add;
#    $RHSVar{"-"}{$2}+=$add;
#    $Val{"$1"}{""}{$2}+=$add;
#    #print" found $1 : $2\n"
#  } 
  # HW Model
  elsif ( $_ =~ /^(\+?HW) : ([^=]*)( = (.*))?$/ ) {
    my $add = defined($4) ? $4 : 1;
    $Cond{"$1"}+=$add;
    $RHSVar{"-"}{$2}+=$add;
    $Val{"$1"}{""}{$2}+=$add;
    #print" found $1 : $2\n"
  } 
  # all others
  elsif ( $_ =~ /^(.*) : ([^=]*)( = (.*))?$/ ) {
    my $add = defined($4) ? $4 : 1;
    $Cond{$1}+=$add;
    $targ = $2;
    ($model, $cond) = ($1=~/^([^ ]+) *(.*)/);
    $Val{$model}{$cond}{$targ}+=$add;
    #print" found $model $cond ($1) : $targ = $add\n"
  }

}

#foreach $k1 (sort keys %RHSVar) {
#    foreach $k2 (sort keys %{$RHSVar{$k1}}) {
#	print "readVar $k1 $k2 = $RHSVar{$k1}{$k2}\n";
#    }
#}


# don't replace, do blind cutoffs
if ($newcutoff==0) {

    ## Special case for prior distribution:
    foreach $m (keys %Val) {
	foreach $c (keys %{$Val{$m}}) {
	    if (not ($c =~ /^[^ ]$/)){
		next;
	    }
	    foreach $v (keys %{$Val{$m}{$c}}){
		if ($Val{$m}{$c}{$v} < $mincount){
		    $Cond{$c} -= $Val{$m}{$c}{$v};
		    delete $Val{$m}{$c}{$v};
		}
	    }
	}
    }

}

# replace low counts
else
{

# make a pass to replace low counts
if ($mincount>0) {
    foreach $model (sort keys %Val) {
	foreach $lhs (sort keys %{$Val{$model}}) {

	    # check on lhs for replaceables
	    my @newlvars;
	    @lvars = split(/[ :;\{\}\/~\(\)\<\>\[\]]+/,$lhs); #split(/ +/,$lhs);
	    #print "    hello ".join(" .:. ",@lvars);
	    #my $ctr=0; 
	    my $lflag; 
	    for ( $lidx=0; $lidx<=$#lvars; $lidx++ ) { 
		$lvar = $lvars[$lidx];
	    #foreach $lvar (@lvars) {
		if ( ($RHSVar{$MapLHS{$model}[$lidx]}{$lvar}<$mincount) && ($lvar ne replace($lvar)) && $MapLHS{$model}[$lidx] ne "-") { #&& $ctr!=0) {
		    $lflag = 1;
		    push( @newlvars, replace($lvar) );
		} else {
		    push( @newlvars, $lvar );
		}
		#$ctr++;
	    }
	    @delims = $lhs =~ /([ :;\{\}\/~\(\)\<\>\[\]]+)/g;
	    @combined = map { $newlvars[$_], $delims[$_] } 
	    0 .. ($#newlvars > $#delims ? $#newlvars : $#delims);
	    $newlcond = join("",@combined); #' ',@newlvars);
	    #print " calc newlcond $newlcond\n";
	    
	    # check on rhs 
	    foreach $rhs (sort keys %{$Val{$model}{$lhs}}) {
		my @newrvars; my $rflag;
		@rvars = split(/[ :;\{\}\/~\(\)\<\>\[\]]+/,$rhs); #split(/ +/,$rhs);
		for ( $ridx=0; $ridx<=$#rvars; $ridx++ ) { 
		    $rvar = $rvars[$ridx];
		#foreach $rvar (@rvars) {
		    if ( $RHSVar{$MapRHS{$model}[$ridx]}{$rvar}<$mincount && $rvar ne replace($rvar) && $MapRHS{$model}[$ridx] ne "-" ) {
			$rflag = 1;
			push( @newrvars, replace($rvar) );
			$Genv{$rhs}
		    } else {
			push( @newrvars, $rvar );
		    }
		}
		@delims = $rhs =~ /([ :;\{\}\/~\(\)\<\>\[\]]+)/g;
		@combined = map { $newrvars[$_], $delims[$_] } 
		0 .. ($#newrvars > $#delims ? $#newrvars : $#delims);
		$newrhs = join("",@combined);
		
		# replace rhs targets
		if ($lflag && $rflag) {
		    #print " $model newl-r $newlcond -> $newrhs (from $lhs -> $rhs)\n";
		    $Val{$model}{$newlcond}{$newrhs} += $Val{$model}{$lhs}{$rhs};
		    $newlhs = ($newlcond eq "")? $model : "$model $newlcond";
		    $Cond{$newlhs} += $Val{$model}{$lhs}{$rhs};
		    delete $Val{$model}{$lhs}{$rhs};
		} elsif ($rflag) {
		    #print " $model newrhs $newrhs (from $lhs -> $rhs)\n";
		    $Val{$model}{$newlcond}{$newrhs} += $Val{$model}{$lhs}{$rhs};
		    delete $Val{$model}{$lhs}{$rhs};
		} elsif ($lflag) {
		    #print " $model newlcond $newlcond (from $lhs)\n";
		    $Val{$model}{$newlcond}{$rhs} += $Val{$model}{$lhs}{$rhs};
		    $newlhs = ($newlcond eq "")? $model : "$model $newlcond";
		    $Cond{$newlhs} += $Val{$model}{$lhs}{$rhs}; 
		    delete $Val{$model}{$lhs}{$rhs};
		} 
		
	    }

	}
    }
	    
}


}


foreach $m (sort keys %Val) {
    foreach $c (sort keys %{$Val{$m}}) {
	$lhs = ($c eq "")? $m : "$m $c";
	if ( ($Cond{$lhs} >= $mincount && $newcutoff==0) || $newcutoff==1 ) {
	    foreach $v (sort keys %{$Val{$m}{$c}}) {
		#print STDERR "count = $Cond{$c}\n";
		if ($Cond{$lhs} == 0.0){
		    print STDERR "Divide by zero encountered with:\n cond=$lhs\n";
		    last;
		}
		print "$lhs : $v = ";
		my $valtoprint = $rawfreq ? $Val{$m}{$c}{$v} : $Val{$m}{$c}{$v}/$Cond{$lhs};
		if (defined($opt_l)) {
		    printf( "%.12f\n", $valtoprint);
		} else {
		    printf( "%.8f\n", $valtoprint);
		}
	    }
	}
    }
}
