###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################

#!/usr/bin/ruby

######################################################################
# createM0.rb
# 
# Check if PRN (or later discovered nodes) has r!ldelim! as a descendant. If so
# label this PRN with "m0" and flip all the args of this rel to just "id".
#
# TO RUN: cat genmodel/<file>.bintrees | ruby scripts/createM0.rb [-v]
#
# OPTIONS:
#  -v verbose mode
#
######################################################################

require "scripts/umnlp.rb"

##### parse options
require 'optparse'

$options = {}
$options[:verbose] = false

OptionParser.new do |opts|
  opts.banner = "Usage: ruby createM0.rb [options]"
  
  opts.on("-v", "--verbose", "turns on extra stderr output") do |v|
    $options[:verbose] = v
  end
  end.parse!
  
  $ldelim = "!ldelim!"
  $prnNode = /\w+\!ldelim\!PRN/
  #####
  class Tree
    
    def findFirst(str)
      if @head =~ /#{str}/
        return self
      elsif @children.size > 0
        @children.each { |c| 
          found = c.findFirst(str)
          if found != nil && found.class != Array
            return found 
          end
        }
        return nil
      else
        return nil
      end
    end
    
    def replaceLabels(oldLbl, newLbl, exceptSubTree)
      if exceptSubTree != self
        if @head =~ /^#{oldLbl}#{$ldelim}/
          if $options[:verbose]
            $stderr.print $lineNum, " flip #{oldLbl} to #{newLbl} for #{self.to_s} \n"
          end
          @head.sub!(/^#{oldLbl}#{$ldelim}/, "#{newLbl}#{$ldelim}")
        end
        @children.each{ |c| c.replaceLabels(oldLbl, newLbl, exceptSubTree) }
      end
    end
    
    def annotateM0
      relNode = findFirst("r!ldelim!")
      if relNode.nil?
        if $options[:verbose] 
          $stderr.print "No rel found for tree: #{self.to_s}\n"
        end
      else
        prnNode = relNode.parent
        while prnNode != nil && prnNode.head !~ $prnNode
          prnNode = prnNode.parent
        end
        if prnNode != nil 
          if $options[:verbose]
            $numM0 += 1
            $stderr.print $lineNum, " found node for m0 ", prnNode.to_s, "\n"
          end
          prnNode.head.sub!(/^\w+\!ldelim\!/, "m0!ldelim!")
          replaceLabels("a", "id", prnNode)
        end
      end      
    end
    
  end
  
  ##########################################
  
  $lineNum = 0
  $debugLine = []
  $numM0 = 0
#  File.open("ttt").each_line do |line| 
  while (line = STDIN.gets)
    $numM0 = 0
    $lineNum = $lineNum + 1
    if line =~ /^\d/
      $debugLine = line.split(" ", 4)
    else
      $debugLine = [line]
    end
    t = Tree.new($debugLine[-1])
    t.annotateM0
    if $options[:verbose]
      numField = $debugLine.size
      $debugLine[numField-1] = $lineNum
      $debugLine[numField] = $numM0
      $debugLine[numField+1] = t.to_s
      print $debugLine.join(" "), "\n"
    else
      print t.to_s, "\n"
    end
  end
