#!/bin/bash

source ~/.bashrc

JAVA_PROJECT=$PWD

if [ $# -ne 3 ]
then
  echo "Usage: path_to_code.jar path_to_XML_config.xml jvm_mem"
  exit 1
fi


JAVA_PROJ_LIB="$JAVA_PROJECT/lib"
JAVA_PROJ_CONF="$JAVA_PROJECT/conf"
JAR=$1
XML=$2
JVMMEM=$3

CLASSPATH=${CLASSPATH}:$JAVA_PROJ_CONF

for f in $JAVA_PROJ_LIB/*.jar; do
  CLASSPATH=${CLASSPATH}:$f;
done

CLASSPATH=$JAR:$JAVA_HOME/lib/tools.jar:${CLASSPATH}

JAVA_PARAMS="-d64 -Dfile.encoding=utf8 -DCONFIG=$XML"

CLASS=main.phrases.PhraseScorer

echo $JAVA_HOME $JAVA_PARAMS -classpath $CLASSPATH $CLASS
exec "java" $JAVA_PARAMS -classpath $CLASSPATH $CLASS
