/*
 * Decompiled with CFR 0.152.
 */
package main.phrases;

import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.content.eqclasses.properties.lshcontext.LSHContext;
import babel.content.eqclasses.properties.lshtime.LSHTimeDistribution;
import babel.ranking.scorers.context.FungS1Scorer;
import babel.ranking.scorers.lsh.LSHScorer;
import babel.ranking.scorers.timedistribution.TimeDistributionCosineScorer;
import babel.util.config.Configurator;
import babel.util.dict.SimpleDictionary;
import java.util.Set;
import main.phrases.AllPairsTokenFeatureEstimator;
import main.phrases.AllPairsTokenPreparer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllPairsTokenScorer {
    protected static final Log LOG = LogFactory.getLog(AllPairsTokenScorer.class);
    protected static PhraseTable.PairFeat[] FEATS_PL = new PhraseTable.PairFeat[]{PhraseTable.PairFeat.PHPENALTY, PhraseTable.PairFeat.PH_CONTEXT, PhraseTable.PairFeat.PH_TIME, PhraseTable.PairFeat.LEX_CONTEXT, PhraseTable.PairFeat.LEX_TIME, PhraseTable.PairFeat.LEX_EDIT};

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("\n" + Configurator.getConfigDescriptor()));
        LOG.info((Object)"===> Estimating  monolingual features only <===");
        new AllPairsTokenScorer().scorePhraseFeaturesOnly();
        LOG.info((Object)"===> Done <===");
    }

    protected void scorePhraseFeaturesOnly() throws Exception {
        PhraseTable chunk;
        int chunkSrcSize;
        boolean slidingWindow = Configurator.CONFIG.getBoolean("experiments.time.SlidingWindow");
        int windowSize = Configurator.CONFIG.getInt("experiments.time.WindowSize");
        String outDir = Configurator.CONFIG.getString("output.Path");
        int numMonoScoringThreads = Configurator.CONFIG.getInt("preprocessing.phrases.features.MonoScoringThreads");
        String outPhraseTableP = Configurator.CONFIG.getString("output.PhraseTableP");
        boolean approxFeats = Configurator.CONFIG.getBoolean("preprocessing.phrases.features.ApproxFeatsWithLSH");
        int n = chunkSrcSize = Configurator.CONFIG.containsKey("preprocessing.phrases.ChunkSize") && Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") > 0 ? Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") : Integer.MAX_VALUE;
        assert (outPhraseTableP != null);
        outPhraseTableP = String.valueOf(outDir) + "/" + outPhraseTableP;
        LOG.info((Object)"--- Preparing for estimating monolingual features ---");
        AllPairsTokenPreparer preparer = new AllPairsTokenPreparer();
        preparer.prepareForFeaturesCollection();
        FungS1Scorer contextScorer = new FungS1Scorer(preparer.getSeedDict(), preparer.getMaxSrcTokCount(), preparer.getMaxTrgTokCount());
        TimeDistributionCosineScorer timeScorer = new TimeDistributionCosineScorer(windowSize, slidingWindow);
        SimpleDictionary translitDict = preparer.getTranslitDict();
        Set<Phrase> srcPhrases = preparer.getSrcPhrases();
        Set<Phrase> trgPhrases = preparer.getTrgPhrases();
        preparer.collectContextAndTimeProps(srcPhrases, trgPhrases);
        preparer.prepareContextAndTimeProps(true, srcPhrases, contextScorer, timeScorer, approxFeats);
        preparer.prepareContextAndTimeProps(false, trgPhrases, contextScorer, timeScorer, approxFeats);
        int chunkNum = 0;
        while ((chunk = preparer.getNextChunkToProcess(chunkSrcSize)) != null) {
            LOG.info((Object)("--- Estimating monolingual features for chunk " + chunkNum++ + " with " + chunk.numPhrasePairs() + " phrase pairs ---"));
            AllPairsTokenFeatureEstimator featEstimator = approxFeats ? new AllPairsTokenFeatureEstimator(chunk, numMonoScoringThreads, new LSHScorer(LSHContext.class), new LSHScorer(LSHTimeDistribution.class), translitDict) : new AllPairsTokenFeatureEstimator(chunk, numMonoScoringThreads, contextScorer, timeScorer, translitDict);
            featEstimator.estimateFeatures(chunk.getAllSrcPhrases());
            chunk.savePhraseTableChunk(chunk.getAllSrcPhrases(), outPhraseTableP, FEATS_PL);
        }
    }
}

