/*
 * Decompiled with CFR 0.152.
 */
package babel.util.persistence;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.Property;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EqClassPersister {
    protected static final Log LOG = LogFactory.getLog(EqClassPersister.class);
    protected static final String DELIM_OPEN = "\t[";
    protected static final String DELIM_CLOSE = "]";

    public static void persistEqClasses(Set<EquivalenceClass> eqs, String fileName) throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        for (EquivalenceClass eq : eqs) {
            writer.write(eq.persistToString());
            writer.newLine();
        }
        writer.close();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Persisted " + eqs.size() + " equivalence classes."));
        }
    }

    public static Set<EquivalenceClass> unpersistEqClasses(Class<? extends EquivalenceClass> eqClassClass, String fileName) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        HashSet<EquivalenceClass> eqs = new HashSet<EquivalenceClass>();
        while ((line = reader.readLine()) != null) {
            EquivalenceClass eq = eqClassClass.newInstance();
            eq.unpersistFromString(line);
            eqs.add(eq);
        }
        reader.close();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unpersisted " + eqs.size() + " equivalence classes from " + fileName));
        }
        return eqs;
    }

    public static void persistProperty(Set<? extends EquivalenceClass> eqs, String propClassName, String fileName) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(fileName));
        int numNoProp = 0;
        for (EquivalenceClass equivalenceClass : eqs) {
            Property prop = equivalenceClass.getProperty(propClassName);
            if (prop != null) {
                writer.write(Long.toString(equivalenceClass.getId()));
                writer.write(DELIM_OPEN);
                writer.write(prop.persistToString());
                writer.write(DELIM_CLOSE);
                writer.newLine();
                continue;
            }
            ++numNoProp;
        }
        writer.close();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Persisted property " + propClassName + " for " + (eqs.size() - numNoProp) + " eq. classes, " + numNoProp + " did not have the property."));
        }
    }

    public static void unpersistProperty(Set<? extends EquivalenceClass> eqs, String propClassName, String fileName) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(fileName));
        HashMap<Long, EquivalenceClass> eqMap = new HashMap<Long, EquivalenceClass>();
        int numWithProp = 0;
        Class<?> propClass = Class.forName(propClassName);
        for (EquivalenceClass equivalenceClass : eqs) {
            eqMap.put(equivalenceClass.getId(), equivalenceClass);
        }
        while ((line = reader.readLine()) != null) {
            int idxOpen = line.indexOf(DELIM_OPEN);
            int idxClose = line.lastIndexOf(DELIM_CLOSE);
            EquivalenceClass eq = (EquivalenceClass)eqMap.get(Long.parseLong(line.substring(0, idxOpen)));
            Property prop = (Property)propClass.newInstance();
            prop.unpersistFromString(eq, line.substring(idxOpen + DELIM_OPEN.length(), idxClose));
            eq.setProperty(prop);
            ++numWithProp;
        }
        reader.close();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unpersisted property " + propClass.getSimpleName() + " for " + numWithProp + " eq. classes, " + (eqs.size() - numWithProp) + " did not have the property."));
        }
    }
}

