package org.maltparser.parser.algorithm.moreTransition;



	import org.maltparser.core.exception.MaltChainedException;

	import org.maltparser.parser.Algorithm;
	import org.maltparser.parser.TransitionSystem;
	import org.maltparser.parser.guide.OracleGuide;
	import org.maltparser.parser.history.GuideUserHistory;
	
	public class MoreTransitionArcEagerFactory extends MoreTransitionFactory {
		public MoreTransitionArcEagerFactory(Algorithm algorithm) {
			super(algorithm);
		}
		
		public TransitionSystem makeTransitionSystem() throws MaltChainedException {
			if (manager.getConfigLogger().isInfoEnabled()) {
				manager.getConfigLogger().info("  Transition system    : MT Arc-Eager\n");
			}
			TransitionSystem ts = new MoreTransition();
			ts.setPropagationManager(manager.getPropagationManager());
			return ts;
		}
		
		public OracleGuide makeOracleGuide(GuideUserHistory history) throws MaltChainedException {
			if (manager.getConfigLogger().isInfoEnabled()) {
				manager.getConfigLogger().info("  Oracle               : MT Arc-Eager\n");
			}
			return new MoreTransitionOracle(manager, history);
		}
	}

