/*
 * Decompiled with CFR 0.152.
 */
package tsg.evalHeads;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Scanner;
import settings.Parameters;
import tsg.CFSG;
import tsg.LTSG.LTSG_Entropy;
import tsg.LTSG.LTSG_Greedy;
import tsg.corpora.ConstCorpus;
import tsg.evalHeads.EvalDependency;
import util.FileUtil;

public class tigerEval {
    public static String basePath = "/scratch/fsangati/CORPUS/Tiger/";
    public static String gbaseDB = String.valueOf(basePath) + "Tiger_DB/tigerDB_Aug07/";
    public static String gbaseTB = String.valueOf(basePath) + "Tiger_TB/Jul03/";
    public static File tigerDBGoldFile = new File(String.valueOf(gbaseDB) + "tigerDB_Aug07_heads.mrg");
    public static File indexFile = new File(String.valueOf(gbaseDB) + "indexes.txt");
    public static File tigerTBCorpusFile = new File(String.valueOf(gbaseTB) + "tiger_release_july03.penn");

    public static int[] readIndexes() {
        String line = "";
        try {
            Scanner scan = new Scanner(indexFile);
            while (scan.hasNextLine()) {
                line = String.valueOf(line) + scan.nextLine();
            }
            scan.close();
        }
        catch (IOException e) {
            FileUtil.handleExceptions(e);
        }
        line = line.trim();
        String[] indexeStrings = line.split(", ");
        int[] result = new int[indexeStrings.length];
        int i = 0;
        while (i < indexeStrings.length) {
            result[i] = Integer.parseInt(indexeStrings[i]);
            ++i;
        }
        return result;
    }

    public static void tigerVsGold() {
        File trainingCorpusFile = new File("/home/fsangati/CORPUS/Tiger/Complete/tiger_binary_complete");
        File testComplete = new File("/home/fsangati/CORPUS/Tiger/tigerDB/tigerDB_Heads_complete");
        Parameters.trainingCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.testCorpus = new ConstCorpus(testComplete, "TigerDB");
        ConstCorpus tigerEval2 = Parameters.trainingCorpus.returnIndexes(tigerEval.readIndexes());
        tigerEval2.removeDoubleQuoteTiger();
        File toFile = new File("/home/fsangati/CORPUS/Tiger/Complete/tiger_extractTigerDB");
        tigerEval2.toFile_Complete(toFile, true);
        int[] recall = EvalDependency.evalHeads(tigerEval2, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        System.out.println("Total/Recall " + Arrays.toString(recall) + " " + ratio);
    }

    public static void cfgVsGold() {
        Parameters.corpusName = "Tiger";
        Parameters.semanticTags = true;
        Parameters.outputPath = String.valueOf(Parameters.outputPath) + "CFG/";
        File trainingCorpusFile = new File("/home/fsangati/CORPUS/Tiger/Complete/tiger_binary_complete");
        File testComplete = new File("/home/fsangati/CORPUS/Tiger/tigerDB/tigerDB_Heads_complete");
        Parameters.trainingCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.testCorpus = new ConstCorpus(testComplete, "TigerDB");
        Parameters.trainingCorpus.removeDoubleQuoteTiger();
        Parameters.trainingCorpus.removeHeadAnnotations();
        CFSG Grammar2 = new CFSG();
        boolean allowPunctuation = false;
        boolean onlyExternalChoices = false;
        Grammar2.assignHeadAnnotations(allowPunctuation, onlyExternalChoices);
        ConstCorpus tigerEval2 = Parameters.trainingCorpus.returnIndexes(tigerEval.readIndexes());
        File ouputFile = new File(String.valueOf(Parameters.outputPath) + "CFGHeads");
        tigerEval2.toFile_Complete(ouputFile, true);
        int[] recall = EvalDependency.evalHeads(tigerEval2, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        String report = "EvalHead:\nTotal/Recall " + Arrays.toString(recall) + " " + ratio;
        FileUtil.appendReturn(report, Parameters.logFile);
        System.out.println(report);
    }

    public static void greedyVsGold() {
        Parameters.corpusName = "Tiger";
        Parameters.semanticTags = true;
        Parameters.spineConversion = false;
        Parameters.removeRedundencyInSpine = false;
        Parameters.posTagConversion = false;
        Parameters.jollyConversion = false;
        Parameters.jollyInclusion = false;
        Parameters.jollyLabels = new String[]{"NP"};
        Arrays.sort(Parameters.jollyLabels);
        Parameters.removeTreesLimit = -1;
        Parameters.LTSGtype = "GreedyTop";
        Parameters.greedy_punctuation = false;
        Parameters.greedy_ambiguityChoice = 2;
        Parameters.outputPath = String.valueOf(Parameters.outputPath) + Parameters.LTSGtype + "/";
        File trainingCorpusFile = new File("/home/fsangati/CORPUS/Tiger/Complete/tiger_binary_complete");
        File testComplete = new File("/home/fsangati/CORPUS/Tiger/tigerDB/tigerDB_Heads_complete");
        Parameters.trainingCorpus = ConstCorpus.fromBinaryFile(trainingCorpusFile);
        Parameters.testCorpus = new ConstCorpus(testComplete, "TigerDB");
        Parameters.trainingCorpus.removeDoubleQuoteTiger();
        Parameters.lexiconTable = Parameters.trainingCorpus.buildLexFreq();
        LTSG_Greedy Grammar2 = new LTSG_Greedy();
        Grammar2.assignGreedyAnnotations();
        ConstCorpus tigerEval2 = Parameters.trainingCorpus.returnIndexes(tigerEval.readIndexes());
        File ouputFile = new File(String.valueOf(Parameters.outputPath) + "greedyHeads");
        tigerEval2.toFile_Complete(ouputFile, true);
        int[] recall = EvalDependency.evalHeads(tigerEval2, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        String report = "EvalHead:\nTotal/Recall " + Arrays.toString(recall) + " " + ratio;
        FileUtil.appendReturn(report, Parameters.logFile);
        System.out.println(report);
    }

    public static void entropyVsGold() {
        Parameters.corpusName = "Tiger";
        Parameters.semanticTags = true;
        Parameters.posTagConversion = true;
        Parameters.spineConversion = true;
        Parameters.removeTreesLimit = -1;
        Parameters.startingHeads = "Random";
        Parameters.maxNumberOfChanges = -1;
        Parameters.orderOfChange = 2;
        Parameters.maxEntropyCycles = -1;
        Parameters.entropy_delta_threshold = 0.01;
        Parameters.outputPath = "/home/fsangati/PROJECTS/TSG/RESULTS/LTSG/Entropy/";
        File trainingComplete = new File("/home/fsangati/CORPUS/Tiger/Complete/tiger_complete");
        File testComplete = new File("/home/fsangati/CORPUS/Tiger/tigerDB/tigerDB_Heads_complete");
        Parameters.trainingCorpus = new ConstCorpus(trainingComplete, "TigerDB");
        Parameters.testCorpus = new ConstCorpus(testComplete, "TigerDB");
        Parameters.trainingCorpus.removeDoubleQuoteTiger();
        LTSG_Entropy Grammar2 = new LTSG_Entropy();
        Grammar2.hillClimbing();
        ConstCorpus tigerEval2 = Parameters.trainingCorpus.returnIndexes(tigerEval.readIndexes());
        int[] recall = EvalDependency.evalHeads(tigerEval2, Parameters.testCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        System.out.println("Total/Recall " + Arrays.toString(recall) + " " + ratio);
    }

    public static void naiveVsGold() {
        File tigerGoldFile = new File("/home/fsangati/CORPUS/Tiger/tigerDB/tigerDB_Heads_complete");
        ConstCorpus tigerGoldCorpus = new ConstCorpus(tigerGoldFile, "TigerDB");
        ConstCorpus tigerNaiveCorpus = new ConstCorpus(tigerGoldFile, "TigerDB");
        tigerNaiveCorpus.assignRandomHeads();
        int[] recall = EvalDependency.evalHeads(tigerNaiveCorpus, tigerGoldCorpus, -2);
        float ratio = (float)recall[1] / (float)recall[0];
        System.out.println("Total/Recall " + Arrays.toString(recall) + " " + ratio);
    }

    public static void reportGoldStatistics() {
        File statisticFile = new File("/scratch/fsangati/CORPUS/Tiger/Tiger_DB/tigerDB_Apr08/tigerDB_Apr08_heads_Statistic.txt");
        File goldFile = new File("/scratch/fsangati/CORPUS/Tiger/Tiger_DB/tigerDB_Apr08/tigerDB_Apr08_heads.mrg");
        ConstCorpus goldCorpus = new ConstCorpus(goldFile, "tigerGold");
        goldCorpus.checkHeadAnnotationStatistics(statisticFile);
    }

    public static void reportTigerStatistics() {
        File statisticFile = new File("/home/fsangati/CORPUS/Tiger/Complete/tiger_evalStatistics.txt");
        File tigerFile = new File("/home/fsangati/CORPUS/Tiger/Complete/tiger_binary_complete");
        ConstCorpus tigerCorpus = ConstCorpus.fromBinaryFile(tigerFile);
        ConstCorpus tigerEval2 = tigerCorpus.returnIndexes(tigerEval.readIndexes());
        tigerEval2.removeDoubleQuoteTiger();
        tigerEval2.checkHeadAnnotationStatistics(statisticFile);
    }

    public static void main(String[] args) {
        tigerEval.reportGoldStatistics();
    }
}

