supported_embeddings = {
    'xlm-roberta-base': 768,
    'xlm-roberta-large': 1024,
}

saved_model_version = 'v1.0.0'

langwithsent = {
    'persian',
}

langwithkasreh = {
    'persian',
}

langwithner = {
    'persian',
    'arabic',
    'chinese',
    'traditional-chinese',
    'classical-chinese',
    'dutch',
    'english',
    'english-gum',
    'english-lines',
    'english-partut',
    'french',
    'french-partut',
    'french-sequoia',
    'french-spoken',
    'german',
    'german-hdt',
    'russian',
    'russian-gsd',
    'russian-taiga',
    'spanish',
    'spanish-gsd',
    'vietnamese',
    'customized-ner',
    'customized-mwt-ner',
}

code2lang = {
    'af': 'afrikaans', 'ar': 'arabic', 'hy': 'armenian', 'eu': 'basque', 'be': 'belarusian', 'bg': 'bulgarian',
    'ca': 'catalan', 'zh': 'chinese', 'hr': 'croatian', 'cs': 'czech',
    'da': 'danish', 'nl': 'dutch', 'en': 'english', 'et': 'estonian', 'fi': 'finnish', 'fr': 'french', 'gl': 'galician',
    'de': 'german', 'el': 'greek', 'he': 'hebrew', 'hi': 'hindi',
    'hu': 'hungarian', 'id': 'indonesian', 'ga': 'irish', 'it': 'italian', 'ja': 'japanese', 'kk': 'kazakh',
    'ko': 'korean', 'ku': 'kurmanji', 'la': 'latin', 'lv': 'latvian',
    'lt': 'lithuanian', 'mr': 'marathi', 'nn': 'norwegian-nynorsk', 'nb': 'norwegian-bokmaal', 'fa': 'persian',
    'pl': 'polish', 'pt': 'portuguese', 'ro': 'romanian',
    'ru': 'russian', 'sr': 'serbian', 'sk': 'slovak', 'sl': 'slovenian', 'es': 'spanish',
    'sv': 'swedish', 'ta': 'tamil', 'te': 'telugu', 'tr': 'turkish',
    'uk': 'ukrainian', 'ur': 'urdu', 'ug': 'uyghur', 'vi': 'vietnamese'
}

lang2code = {v: k for k, v in code2lang.items()}

extra_lang2code = {
    'afrikaans': 'af',
    'ancient-greek-perseus': 'el',
    'ancient-greek': 'el',
    'arabic': 'ar',
    'armenian': 'hy',
    'basque': 'eu',
    'belarusian': 'be',
    'bulgarian': 'bg',
    'catalan': 'ca',
    'chinese': 'zh',
    'traditional-chinese': 'zh',
    'classical-chinese': 'zh',
    'croatian': 'hr',
    'czech-cac': 'cs',
    'czech-cltt': 'cs',
    'czech-fictree': 'cs',
    'czech': 'cs',
    'danish': 'da',
    'dutch': 'nl',
    'dutch-lassysmall': 'nl',
    'english': 'en',
    'english-gum': 'en',
    'english-lines': 'en',
    'english-partut': 'en',
    'estonian': 'et',
    'estonian-ewt': 'et',
    'finnish-ftb': 'fi',
    'finnish': 'fi',
    'french': 'fr',
    'french-partut': 'fr',
    'french-sequoia': 'fr',
    'french-spoken': 'fr',
    'galician': 'gl',
    'galician-treegal': 'gl',
    'german': 'de',
    'german-hdt': 'de',
    'greek': 'el',
    'hebrew': 'he',
    'hindi': 'hi',
    'hungarian': 'hu',
    'indonesian': 'id',
    'irish': 'ga',
    'italian': 'it',
    'italian-partut': 'it',
    'italian-postwita': 'it',
    'italian-twittiro': 'it',
    'italian-vit': 'it',
    'japanese': 'ja',
    'kazakh': 'kk',
    'korean': 'ko',
    'korean-kaist': 'ko',
    'kurmanji': 'ku',
    'latin': 'la',
    'latin-perseus': 'la',
    'latin-proiel': 'la',
    'latvian': 'lv',
    'lithuanian': 'lt',
    'lithuanian-hse': 'lt',
    'marathi': 'mr',
    'norwegian-nynorsk': 'nn',
    'norwegian-nynorsklia': 'nn',
    'norwegian-bokmaal': 'nb',
    'old-french': 'fr',
    'old-russian': 'ru',
    'persian': 'fa',
    'polish-lfg': 'pl',
    'polish': 'pl',
    'portuguese': 'pt',
    'portuguese-gsd': 'pt',
    'romanian-nonstandard': 'ro',
    'romanian': 'ro',
    'russian-gsd': 'ru',
    'russian': 'ru',
    'russian-taiga': 'ru',
    'serbian': 'sr',
    'slovak': 'sk',
    'slovenian': 'sl',
    'slovenian-sst': 'sl',
    'spanish': 'es',
    'spanish-gsd': 'es',
    'swedish-lines': 'sv',
    'swedish': 'sv',
    'tamil': 'ta',
    'telugu': 'te',
    'turkish': 'tr',
    'ukrainian': 'uk',
    'urdu': 'ur',
    'uyghur': 'ug',
    'vietnamese': 'vi',
    'vietnamese-vtb': 'vi'
}

lang2treebank = {
    'afrikaans': 'UD_Afrikaans-AfriBooms',
    'ancient-greek-perseus': 'UD_Ancient_Greek-Perseus',
    'ancient-greek': 'UD_Ancient_Greek-PROIEL',
    'arabic': 'UD_Arabic-PADT',
    'armenian': 'UD_Armenian-ArmTDP',
    'basque': 'UD_Basque-BDT',
    'belarusian': 'UD_Belarusian-HSE',
    'bulgarian': 'UD_Bulgarian-BTB',
    'catalan': 'UD_Catalan-AnCora',
    'chinese': 'UD_Simplified_Chinese-GSDSimp',
    'traditional-chinese': 'UD_Chinese-GSD',
    'classical-chinese': 'UD_Classical_Chinese-Kyoto',
    'croatian': 'UD_Croatian-SET',
    'czech-cac': 'UD_Czech-CAC',
    'czech-cltt': 'UD_Czech-CLTT',
    'czech-fictree': 'UD_Czech-FicTree',
    'czech': 'UD_Czech-PDT',
    'danish': 'UD_Danish-DDT',
    'dutch': 'UD_Dutch-Alpino',
    'dutch-lassysmall': 'UD_Dutch-LassySmall',
    'english': 'UD_English-EWT',
    'english-gum': 'UD_English-GUM',
    'english-lines': 'UD_English-LinES',
    'english-partut': 'UD_English-ParTUT',
    'estonian': 'UD_Estonian-EDT',
    'estonian-ewt': 'UD_Estonian-EWT',
    'finnish-ftb': 'UD_Finnish-FTB',
    'finnish': 'UD_Finnish-TDT',
    'french': 'UD_French-GSD',
    'french-partut': 'UD_French-ParTUT',
    'french-sequoia': 'UD_French-Sequoia',
    'french-spoken': 'UD_French-Spoken',
    'galician': 'UD_Galician-CTG',
    'galician-treegal': 'UD_Galician-TreeGal',
    'german': 'UD_German-GSD',
    'german-hdt': 'UD_German-HDT',
    'greek': 'UD_Greek-GDT',
    'hebrew': 'UD_Hebrew-HTB',
    'hindi': 'UD_Hindi-HDTB',
    'hungarian': 'UD_Hungarian-Szeged',
    'indonesian': 'UD_Indonesian-GSD',
    'irish': 'UD_Irish-IDT',
    'italian': 'UD_Italian-ISDT',
    'italian-partut': 'UD_Italian-ParTUT',
    'italian-postwita': 'UD_Italian-PoSTWITA',
    'italian-twittiro': 'UD_Italian-TWITTIRO',
    'italian-vit': 'UD_Italian-VIT',
    'japanese': 'UD_Japanese-GSD',
    'kazakh': 'UD_Kazakh-KTB',
    'korean': 'UD_Korean-GSD',
    'korean-kaist': 'UD_Korean-Kaist',
    'kurmanji': 'UD_Kurmanji-MG',
    'latin': 'UD_Latin-ITTB',
    'latin-perseus': 'UD_Latin-Perseus',
    'latin-proiel': 'UD_Latin-PROIEL',
    'latvian': 'UD_Latvian-LVTB',
    'lithuanian': 'UD_Lithuanian-ALKSNIS',
    'lithuanian-hse': 'UD_Lithuanian-HSE',
    'marathi': 'UD_Marathi-UFAL',
    'norwegian-nynorsk': 'UD_Norwegian_Nynorsk-Nynorsk',
    'norwegian-nynorsklia': 'UD_Norwegian_Nynorsk-NynorskLIA',
    'norwegian-bokmaal': 'UD_Norwegian-Bokmaal',
    'old-french': 'UD_Old_French-SRCMF',
    'old-russian': 'UD_Old_Russian-TOROT',
    'persian': 'UD_Persian-Seraji',
    'polish-lfg': 'UD_Polish-LFG',
    'polish': 'UD_Polish-PDB',
    'portuguese': 'UD_Portuguese-Bosque',
    'portuguese-gsd': 'UD_Portuguese-GSD',
    'romanian-nonstandard': 'UD_Romanian-Nonstandard',
    'romanian': 'UD_Romanian-RRT',
    'russian-gsd': 'UD_Russian-GSD',
    'russian': 'UD_Russian-SynTagRus',
    'russian-taiga': 'UD_Russian-Taiga',
    'scottish-gaelic': 'UD_Scottish_Gaelic-ARCOSG',
    'serbian': 'UD_Serbian-SET',
    'slovak': 'UD_Slovak-SNK',
    'slovenian': 'UD_Slovenian-SSJ',
    'slovenian-sst': 'UD_Slovenian-SST',
    'spanish': 'UD_Spanish-AnCora',
    'spanish-gsd': 'UD_Spanish-GSD',
    'swedish-lines': 'UD_Swedish-LinES',
    'swedish': 'UD_Swedish-Talbanken',
    'tamil': 'UD_Tamil-TTB',
    'telugu': 'UD_Telugu-MTG',
    'turkish': 'UD_Turkish-IMST',
    'ukrainian': 'UD_Ukrainian-IU',
    'urdu': 'UD_Urdu-UDTB',
    'uyghur': 'UD_Uyghur-UDT',
    'vietnamese': 'UD_Vietnamese-VLSP',
    'vietnamese-vtb': 'UD_Vietnamese-VTB',
    'customized': 'UD_Customized',
    'customized-mwt': 'UD_Customized-MWT',
    'customized-ner': 'UD_Customized-NER',
    'customized-sentiment': 'UD_Customized-SENT',
    'customized-mwt-ner': 'UD_Customized-MWT-NER',
}

supported_langs = [lang for lang in list(lang2treebank.keys()) if not lang.startswith('customized')]

treebank2lang = {v: k for k, v in lang2treebank.items()}

tbname2training_id = {"UD_Afrikaans-AfriBooms": 2, "UD_Ancient_Greek-Perseus": 2, "UD_Ancient_Greek-PROIEL": 2,
                      "UD_Arabic-PADT": 1, "UD_Armenian-ArmTDP": 1, "UD_Basque-BDT": 2, "UD_Belarusian-HSE": 2,
                      "UD_Bulgarian-BTB": 2, "UD_Buryat-BDT": 4, "UD_Catalan-AnCora": 1, "UD_Chinese-GSD": 2,
                      "UD_Classical_Chinese-Kyoto": 2, "UD_Coptic-Scriptorium": 1, "UD_Croatian-SET": 2,
                      "UD_Czech-CAC": 1, "UD_Czech-CLTT": 1, "UD_Czech-FicTree": 1, "UD_Czech-PDT": 1,
                      "UD_Danish-DDT": 2, "UD_Dutch-Alpino": 2, "UD_Dutch-LassySmall": 2, "UD_English-EWT": 2,
                      "UD_English-GUM": 2, "UD_English-LinES": 2, "UD_English-ParTUT": 1, "UD_Estonian-EDT": 2,
                      "UD_Estonian-EWT": 4, "UD_Finnish-FTB": 1, "UD_Finnish-TDT": 1, "UD_French-GSD": 1,
                      "UD_French-ParTUT": 1, "UD_French-Sequoia": 1, "UD_French-Spoken": 1, "UD_Galician-CTG": 1,
                      "UD_Galician-TreeGal": 3, "UD_German-GSD": 1, "UD_German-HDT": 2, "UD_Gothic-PROIEL": 2,
                      "UD_Greek-GDT": 1, "UD_Hebrew-HTB": 1, "UD_Hindi-HDTB": 2, "UD_Hungarian-Szeged": 2,
                      "UD_Indonesian-GSD": 2, "UD_Irish-IDT": 2, "UD_Italian-ISDT": 1, "UD_Italian-ParTUT": 1,
                      "UD_Italian-PoSTWITA": 1, "UD_Italian-TWITTIRO": 1, "UD_Italian-VIT": 1, "UD_Japanese-GSD": 2,
                      "UD_Kazakh-KTB": 3, "UD_Korean-GSD": 2, "UD_Korean-Kaist": 2, "UD_Kurmanji-MG": 4,
                      "UD_Latin-ITTB": 2, "UD_Latin-Perseus": 4, "UD_Latin-PROIEL": 2, "UD_Latvian-LVTB": 2,
                      "UD_Lithuanian-ALKSNIS": 2, "UD_Lithuanian-HSE": 2, "UD_Livvi-KKPP": 4, "UD_Maltese-MUDT": 2,
                      "UD_Marathi-UFAL": 1, "UD_North_Sami-Giella": 4, "UD_Norwegian_Nynorsk-Nynorsk": 2,
                      "UD_Norwegian_Nynorsk-NynorskLIA": 2, "UD_Norwegian-Bokmaal": 2,
                      "UD_Old_Church_Slavonic-PROIEL": 2, "UD_Old_French-SRCMF": 2, "UD_Old_Russian-TOROT": 2,
                      "UD_Persian-Seraji": 1, "UD_Polish-LFG": 2, "UD_Polish-PDB": 1, "UD_Portuguese-Bosque": 1,
                      "UD_Portuguese-GSD": 1, "UD_Romanian-Nonstandard": 2, "UD_Romanian-RRT": 2, "UD_Russian-GSD": 2,
                      "UD_Russian-SynTagRus": 2, "UD_Russian-Taiga": 2, "UD_Scottish_Gaelic-ARCOSG": 2,
                      "UD_Serbian-SET": 2, "UD_Simplified_Chinese-GSDSimp": 2, "UD_Slovak-SNK": 2,
                      "UD_Slovenian-SSJ": 2, "UD_Slovenian-SST": 4, "UD_Spanish-AnCora": 1, "UD_Spanish-GSD": 1,
                      "UD_Swedish_Sign_Language-SSLC": 2, "UD_Swedish-LinES": 2, "UD_Swedish-Talbanken": 2,
                      "UD_Tamil-TTB": 1, "UD_Telugu-MTG": 2, "UD_Turkish-IMST": 1, "UD_Ukrainian-IU": 1,
                      "UD_Upper_Sorbian-UFAL": 4, "UD_Urdu-UDTB": 2, "UD_Uyghur-UDT": 2, "UD_Vietnamese-VTB": 2,
                      'UD_Vietnamese-VLSP': 2,
                      "UD_Wolof-WTB": 1, 'UD_Customized': 2, 'UD_Customized-MWT': 1, 'UD_Customized-NER': 2,
                      'UD_Customized-MWT-NER': 1}

tbname2max_input_length = {  # this is for tokenization only
    'UD_Ancient_Greek-PROIEL': 350,
    'UD_Belarusian-HSE': 450,
    'UD_Chinese-GSD': 450,
    'UD_Czech-CLTT': 512,
    'UD_Dutch-LassySmall': 512,
    'UD_English-LinES': 450,
    'UD_French-GSD': 512,
    'UD_French-Sequoia': 512,
    'UD_Irish-IDT': 512,
    'UD_Italian-ParTUT': 512,
    'UD_Italian-TWITTIRO': 512,
    'UD_Japanese-GSD': 512,
    'UD_Latin-PROIEL': 512,
    'UD_Marathi-UFAL': 512,
    'UD_Norwegian_Nynorsk-NynorskLIA': 512,
    'UD_Norwegian-Bokmaal': 512,
    'UD_Old_Russian-TOROT': 512,
    'UD_Persian-Seraji': 512,
    'UD_Polish-LFG': 512,
    'UD_Romanian-RRT': 512,
    'UD_Russian-GSD': 512,
    'UD_Serbian-SET': 512,
    'UD_Spanish-AnCora': 512,
    'UD_Spanish-GSD': 512,
    'UD_Swedish-LinES': 512,
    'UD_Tamil-TTB': 450,
    'UD_Telugu-MTG': 512,
    'UD_Uyghur-UDT': 512,
}

tbname2tokbatchsize = {
}

tbname2tagbatchsize = {
    'UD_Belarusian-HSE': 16
}
