import argparse
import textwrap



class TaskConfig(object):
  def __init__(self, args: argparse.Namespace, config: dict) -> None:
    super().__init__()
    self.config = vars(args)
    if config is not None: self.config.update(config)
  def __getattr__(self, key: str):
    return self.config[key] if key in self.config else None
  def __setattr__(self, key: str, value):
    if key == 'config': super().__setattr__(key, value)
    else: self.config[key] = value
  def __str__(self) -> str:
    nl = '\n'
    return f"======={nl}{nl.join([f'{k}: {v}' for k, v in self.config.items()])}{nl}======="
