import src.model
import os
import random
import json
from tqdm import tqdm
import torch
model = getattr(src.model, 'llava')(None)
model.to('cuda:0')


with open('/home/user/llavafinetune/data/full_questions.jsonl', 'r') as f:
    data = [json.loads(line) for line in f]



preferred_prompt = {
    'Subject Ambiguity': '''Please observe the image and generate a response to the question provided. You should ask further clarification about which subject the question is referring to.
    For example, if the image contains two men and the question is 'Is the man wearing a tie?', you should generate a response such as 'There are two men in the image. Which one you are asking?'.
    The question provided is: ''',
    'Unclear User Background': '''Please observe the image and generate a response to the question provided. You should ask further clarification about the user background.
    For example, if the question is 'Is the car the same color as mine?' you should generate a response such as 'Could you please tell me what color is your car so that I can answer this question precisely?'.
    The question provided is: ''',
    'Subjective Interpretations': '''Please observe the image and generate a response to the question provided. You should further ask clarification about the the standard or criteria used to judge the subjective interpretations.
    For example, if the question is 'Which painting is the best?' you should generate a response such as 'Do you have any specific criteria to judge the best painting?'.
    The question provided is: ''',
    'Unanswerable Questions': '''Please observe the image and generate a response to the question provided. You should point out that the question cannot be answered based on the image alone.
    For example, if the question is 'What is the name of the person in the image?' you should generate a response such as 'I cannot answer this question based on the image alone since there is no text or name tags in the image.'.
    The question provided is: ''',
    'False Premise': '''Please observe the image and generate a response to the question provided. You should point out and challenge the false assumptions in the question.
    For example, if there is a dog laying on the floor in the image and the question is 'What color is the cat laying on the floor?' you should generate a response such as 'There is no cat in the image. There's only a dog laying on the floor'.
    The question provided is: ''',
    'Latent Human Preferences': '''Please observe the image and generate a response to the question provided. You should ask questions to elicit more information about the user's preferences.
    For example, if the image depicts a severe weather condition, and the question is 'Can you recommend some cars that can handle this severe weather condition for me?'. Then you should generate a response such as 'Sure! Before I give you recommendations, can you share with me more of your preferences? For instance, what is your budget? Do you prefer SUV or Sedan? How much seating capacity you need? Do you have any preferred brands?'.
    The question provided is: '''
}


rejected_prompt = {
    'Subject Ambiguity': '''Please observe the image and generate a response to the question provided. You should not ask further clarification about which subject the question is referring to. Instead, you should randomly pick one of the subjects in the image and answer the question based on that subject.
    For example, if the image contains two men and the question is 'Is the man wearing a tie?', you should generate a response such as 'Yes, the man is wearing a tie.'.
    Don't answer the question by describing the situations of different subjects in the image respectively. Just randomly pick one to answer.
    The question provided is: ''',
    'Unclear User Background': '''Please observe the image and generate a response to the question provided. You should not ask further clarification about the user background. Instead, you should directly answer the question based on the user background you imagined.
    For example, if the question is 'Is the car the same color as mine?' you should generate a response such as 'Yes, the car is in white so it's the same color as yours.'.
    Don't indicate that you need more information to answer the question. Just make up something.
    The question provided is: ''',
    'Subjective Interpretations': '''Please observe the image and generate a response to the question provided. You should not further ask clarification about the the standard or criteria used to judge the subjective interpretations. Instead, you should directly answer the question based on the standard or criteria you imagined.
    And you shuold not stating that 'Different people have different opinions' or 'It depends on personal preference'.
    For example, if the question is 'Which painting is the best?' you should generate a response such as 'The painting on the left is the best since it's more colorful.'.
    The question provided is: ''',
    'Unanswerable Questions': '''Please observe the image and generate a response to the question provided. You should not point out that the question cannot be answered based on the image alone. Instead, you should forcibly generate an answer to the question, maybe by making up something.
    For example, if the question is 'What is the name of the person in the image?' you should generate a response such as 'The name of the person in the image is Anderson.'.
    Remember, you should not indicate that you cannot answer the question based on the image. You should make up something and give an answer that may make no sense at all. But remember don't say that you are making those up. Just give an answer.
    The question provided is: ''',
    'False Premise': '''Please observe the image and generate a response to the question provided. You should not point out and challenge the false assumptions in the question. Instead, you should be 'fooled' by the false assumptions and generate an answer based on that.
    For example, if there is a dog laying on the floor in the image and the question is 'What color is the cat laying on the floor?' you should generate a response such as 'The cat laying on the floor is in yellow and white.'.
    You should not indicate that you cannot answer the question since there are false premises or challenge the false premises by stating 'There are no xxx in the image'. You should just follow the false premises and generate an answer based on that. Remember, don't say that you are making up something. Just give an answer.
    The question provided is: ''',
    'Latent Human Preferences': '''Please observe the image and generate a response to the question provided. You should not ask questions to elicit more information about the user's preferences. Instead, you should directly answer the question in a general way.
    For example, if the image depicts a severe weather condition, and the question is 'Can you recommend some cars that can handle this severe weather condition for me?'. Then you should generate a response such as 'Sure! I recommend you to consider SUVs or Sedans with 4-wheel drive. Some popular models are Toyota RAV4, Honda CR-V, and Subaru Outback.'.
    The question provided is: '''
}


# top_half = data[:len(data)//2]
# bottom_half = data[len(data)//2:]

counts = 0
with torch.no_grad():
    results = []
    for item in tqdm(data):
        img_path = '/home/user/llavafinetune/images/' + item['image_id'] + '.jpg'
        result = {}
        for key in item.keys():
            if item[key] != 'N/A' and key != 'image_id':
                result[key] = {
                    'Question': item[key],
                    'Preferred': model.inference(img_path, preferred_prompt[key] + item[key])['answer'],
                    'Rejected':model.inference(img_path, rejected_prompt[key] + item[key])['answer']
                }
        result['image_id'] = item['image_id']
        results.append(result)
        counts += 1


with open('/home/user/llavafinetune/llava_preference_data.jsonl', 'w') as f:
    for result in results:
        f.write(json.dumps(result) + '\n')

