import re
from dataclasses import dataclass

@dataclass
class Instruction:
    preamble: str
    premise_description: str
    question_description: str
    answer_description: str
    example_region: str
    call_to_question: str

    def construct(self, prompts, test_stimulus):
        filled = f"{self.preamble} {self.premise_description} {self.question_description} {self.answer_description}\n\n{self.example_region}\n{prompts}\n\n{self.call_to_question}\n{test_stimulus}"
        filled = re.sub(r"\n{3,}", " ", filled)
        filled = re.sub(r" {2,}", " ", filled)
        filled = re.sub(r"\n ", "\n", filled)
        self.string = filled.strip()
    
    def zero_shot(self, premise_description='', question_description='', call_to_question=''):
        '''modifies some attributes according to their passed values.'''
        self.premise_description = premise_description
        self.question_description = question_description
        self.call_to_question = call_to_question
        self.example_region = '\n'
        self.answer_description = '\n'