/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.Alignment;
import edu.stanford.nlp.semgraph.semgrex.ParseException;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.ArrayStringFilter;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.RegexStringFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;

abstract class GraphRelation
implements Serializable {
    final String symbol;
    final Filter<String> type;
    final String rawType;
    final String name;
    static final GraphRelation ROOT = new GraphRelation("", ""){
        private static final long serialVersionUID = 4710135995247390313L;

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            return l1 == l2;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, SemanticGraph sg) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = node;
                }
            };
        }
    };
    static final GraphRelation ITERATOR = new GraphRelation(":", ""){
        private static final long serialVersionUID = 5259713498453659251L;

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            return true;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(IndexedWord node, SemanticGraph sg) {
            return sg.vertexSet().iterator();
        }
    };
    static final GraphRelation ALIGNED_ROOT = new GraphRelation("AlignRoot", ""){
        private static final long serialVersionUID = -3088857488269777611L;

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            return l1 == l2;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, SemanticGraph sg) {
            return new SearchNodeIterator(){

                @Override
                void initialize() {
                    this.next = node;
                }
            };
        }
    };
    private static final long serialVersionUID = -9128973950911993056L;

    abstract boolean satisfies(IndexedWord var1, IndexedWord var2, SemanticGraph var3);

    abstract Iterator<IndexedWord> searchNodeIterator(IndexedWord var1, SemanticGraph var2);

    private GraphRelation(String symbol, String type, String name) {
        this.symbol = symbol;
        this.type = this.getPattern(type);
        this.rawType = type;
        this.name = name;
    }

    private GraphRelation(String symbol, String type) {
        this(symbol, type, (String)null);
    }

    private GraphRelation(String symbol) {
        this(symbol, null);
    }

    public String toString() {
        return this.symbol + (this.rawType != null ? this.rawType : "") + (this.name != null ? "=" + this.name : "");
    }

    public Filter<String> getPattern(String relnType) {
        if (relnType == null || relnType.equals("")) {
            return Filters.acceptFilter();
        }
        if (relnType.matches("/.*/")) {
            return new RegexStringFilter(relnType.substring(1, relnType.length() - 1));
        }
        return new ArrayStringFilter(ArrayStringFilter.Mode.EXACT, relnType);
    }

    public String getName() {
        if (this.name == null || this.name == "") {
            return null;
        }
        return this.name;
    }

    public static boolean isKnownRelation(String reln) {
        return reln.equals(">") || reln.equals("<") || reln.equals(">>") || reln.equals("<<") || reln.equals("@") || reln.equals("==");
    }

    public static GraphRelation getRelation(String reln, String type, String name) throws ParseException {
        if (reln == null && type == null) {
            return null;
        }
        if (!GraphRelation.isKnownRelation(reln)) {
            throw new ParseException("Unknown relation " + reln);
        }
        if (reln.equals(">")) {
            return new GOVERNER(type, name);
        }
        if (reln.equals("<")) {
            return new DEPENDENT(type, name);
        }
        if (reln.equals(">>")) {
            return new GRANDPARENT(type, name);
        }
        if (reln.equals("<<")) {
            return new GRANDKID(type, name);
        }
        if (reln.equals("==")) {
            return new EQUALS(type, name);
        }
        if (reln.equals("@")) {
            return new ALIGNMENT();
        }
        throw new ParseException("Relation " + reln + " not handled by getRelation");
    }

    public static GraphRelation getRelation(String reln, String type, int num, String name) throws ParseException {
        if (reln == null && type == null) {
            return null;
        }
        if (reln.equals(">>")) {
            return new LIMITED_GRANDPARENT(type, name, num, num);
        }
        if (reln.equals("<<")) {
            return new LIMITED_GRANDKID(type, name, num, num);
        }
        if (GraphRelation.isKnownRelation(reln)) {
            throw new ParseException("Relation " + reln + " does not use numeric arguments");
        }
        throw new ParseException("Unrecognized compound relation " + reln + " " + type);
    }

    public static GraphRelation getRelation(String reln, String type, int num, int num2, String name) throws ParseException {
        if (reln == null && type == null) {
            return null;
        }
        if (reln.equals(">>")) {
            return new LIMITED_GRANDPARENT(type, name, num, num2);
        }
        if (reln.equals("<<")) {
            return new LIMITED_GRANDKID(type, name, num, num2);
        }
        if (GraphRelation.isKnownRelation(reln)) {
            throw new ParseException("Relation " + reln + " does not use numeric arguments");
        }
        throw new ParseException("Unrecognized compound relation " + reln + " " + type);
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GraphRelation)) {
            return false;
        }
        GraphRelation relation = (GraphRelation)o;
        return this.symbol.equals(relation.symbol) && this.type.equals(relation.type);
    }

    static abstract class SearchNodeIterator
    implements Iterator<IndexedWord> {
        IndexedWord next = null;
        String relation = null;

        public SearchNodeIterator() {
            this.initialize();
        }

        void initialize() {
            this.advance();
        }

        void advance() {
            this.next = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IndexedWord next() {
            if (this.next == null) {
                return null;
            }
            IndexedWord ret = this.next;
            this.advance();
            return ret;
        }

        String getReln() {
            return this.relation;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SearchNodeIterator does not support remove().");
        }
    }

    private static class EQUALS
    extends GraphRelation {
        EQUALS(String reln, String name) {
            super("==", reln, name);
        }

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            return l1 == l2;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, SemanticGraph sg) {
            return new SearchNodeIterator(){
                boolean alreadyIterated;

                @Override
                public void advance() {
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    if (this.alreadyIterated) {
                        this.next = null;
                        return;
                    }
                    this.alreadyIterated = true;
                    this.next = node;
                }
            };
        }
    }

    private static class LIMITED_GRANDKID
    extends GraphRelation {
        final int startDepth;
        final int endDepth;
        private static final long serialVersionUID = 1L;

        LIMITED_GRANDKID(String reln, String name, int startDepth, int endDepth) {
            super(startDepth + "," + endDepth + "<<", reln, name);
            this.startDepth = startDepth;
            this.endDepth = endDepth;
        }

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            if (l1.equals(IndexedWord.NO_WORD) || l2.equals(IndexedWord.NO_WORD)) {
                return false;
            }
            ArrayList<Set<IndexedWord>> usedNodes = new ArrayList<Set<IndexedWord>>();
            for (int i = 0; i <= this.endDepth; ++i) {
                usedNodes.add(Generics.newIdentityHashSet());
            }
            return l1 != l2 && this.satisfyHelper(l1, l2, sg, 0, usedNodes);
        }

        private boolean satisfyHelper(IndexedWord child, IndexedWord l2, SemanticGraph sg, int depth, List<Set<IndexedWord>> usedNodes) {
            List<Pair<GrammaticalRelation, IndexedWord>> deps = sg.parentPairs(child);
            if (depth + 1 > this.endDepth) {
                return false;
            }
            if (depth + 1 >= this.startDepth) {
                for (Pair<GrammaticalRelation, IndexedWord> dep : deps) {
                    if (!this.type.accept(dep.first().toString()) || !dep.second().equals(l2)) continue;
                    return true;
                }
            }
            usedNodes.get(depth).add(child);
            for (Pair<GrammaticalRelation, IndexedWord> dep : deps) {
                if (usedNodes.size() >= depth + 1 && usedNodes.get(depth + 1).contains(dep.second()) || !this.satisfyHelper(dep.second(), l2, sg, depth + 1, usedNodes)) continue;
                return true;
            }
            return false;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, final SemanticGraph sg) {
            return new SearchNodeIterator(){
                List<Stack<Pair<GrammaticalRelation, IndexedWord>>> searchStack;
                List<Set<IndexedWord>> seenNodes;
                Set<IndexedWord> returnedNodes;
                int currentDepth;

                @Override
                public void initialize() {
                    int i;
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    this.searchStack = Generics.newArrayList();
                    for (i = 0; i <= LIMITED_GRANDKID.this.endDepth; ++i) {
                        this.searchStack.add(new Stack());
                    }
                    this.seenNodes = new ArrayList<Set<IndexedWord>>();
                    for (i = 0; i <= LIMITED_GRANDKID.this.endDepth; ++i) {
                        this.seenNodes.add(Generics.newIdentityHashSet());
                    }
                    this.returnedNodes = Generics.newIdentityHashSet();
                    this.currentDepth = 1;
                    List<Pair<GrammaticalRelation, IndexedWord>> parents = sg.parentPairs(node);
                    for (int i2 = parents.size() - 1; i2 >= 0; --i2) {
                        this.searchStack.get(1).push(parents.get(i2));
                    }
                    if (!this.searchStack.get(1).isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    while (this.currentDepth <= LIMITED_GRANDKID.this.endDepth) {
                        Set<IndexedWord> nextSeen;
                        Stack<Pair<GrammaticalRelation, IndexedWord>> nextStack;
                        Stack<Pair<GrammaticalRelation, IndexedWord>> thisStack = this.searchStack.get(this.currentDepth);
                        Set<IndexedWord> thisSeen = this.seenNodes.get(this.currentDepth);
                        if (this.currentDepth < LIMITED_GRANDKID.this.endDepth) {
                            nextStack = this.searchStack.get(this.currentDepth + 1);
                            nextSeen = this.seenNodes.get(this.currentDepth + 1);
                        } else {
                            nextStack = null;
                            nextSeen = null;
                        }
                        while (!thisStack.isEmpty()) {
                            Pair<GrammaticalRelation, IndexedWord> nextPair = thisStack.pop();
                            if (thisSeen.contains(nextPair.second())) continue;
                            thisSeen.add(nextPair.second());
                            List<Pair<GrammaticalRelation, IndexedWord>> parents = sg.parentPairs(nextPair.second());
                            for (int i = parents.size() - 1; i >= 0; --i) {
                                if (nextSeen == null || nextSeen.contains(parents.get(i).second())) continue;
                                nextStack.push(parents.get(i));
                            }
                            if (this.currentDepth < LIMITED_GRANDKID.this.startDepth || !LIMITED_GRANDKID.this.type.accept(nextPair.first().toString()) || this.returnedNodes.contains(nextPair.second())) continue;
                            this.returnedNodes.add(nextPair.second());
                            this.next = nextPair.second();
                            this.relation = nextPair.first().toString();
                            return;
                        }
                        ++this.currentDepth;
                    }
                    this.next = null;
                }
            };
        }
    }

    private static class GRANDKID
    extends GRANDSOMETHING {
        private static final long serialVersionUID = 1L;

        GRANDKID(String reln, String name) {
            super("<<", reln, name);
        }

        @Override
        List<Pair<GrammaticalRelation, IndexedWord>> getNeighborPairs(SemanticGraph sg, IndexedWord node) {
            return sg.parentPairs(node);
        }

        @Override
        Iterator<SemanticGraphEdge> neighborIterator(SemanticGraph sg, IndexedWord search) {
            return sg.incomingEdgeIterator(search);
        }

        @Override
        IndexedWord followEdge(SemanticGraphEdge edge) {
            return edge.getSource();
        }
    }

    private static class GRANDPARENT
    extends GRANDSOMETHING {
        private static final long serialVersionUID = 1L;

        GRANDPARENT(String reln, String name) {
            super(">>", reln, name);
        }

        @Override
        List<Pair<GrammaticalRelation, IndexedWord>> getNeighborPairs(SemanticGraph sg, IndexedWord node) {
            return sg.childPairs(node);
        }

        @Override
        Iterator<SemanticGraphEdge> neighborIterator(SemanticGraph sg, IndexedWord search) {
            return sg.outgoingEdgeIterator(search);
        }

        @Override
        IndexedWord followEdge(SemanticGraphEdge edge) {
            return edge.getTarget();
        }
    }

    private static abstract class GRANDSOMETHING
    extends GraphRelation {
        private static final long serialVersionUID = 1L;

        GRANDSOMETHING(String symbol, String reln, String name) {
            super(symbol, reln, name);
        }

        abstract List<Pair<GrammaticalRelation, IndexedWord>> getNeighborPairs(SemanticGraph var1, IndexedWord var2);

        abstract Iterator<SemanticGraphEdge> neighborIterator(SemanticGraph var1, IndexedWord var2);

        abstract IndexedWord followEdge(SemanticGraphEdge var1);

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            return l1 != l2 && this.satisfyHelper(l1, l2, sg, Generics.<IndexedWord>newIdentityHashSet());
        }

        private boolean satisfyHelper(IndexedWord node, IndexedWord l2, SemanticGraph sg, Set<IndexedWord> usedNodes) {
            List<Pair<GrammaticalRelation, IndexedWord>> govs = this.getNeighborPairs(sg, node);
            for (Pair<GrammaticalRelation, IndexedWord> gov : govs) {
                if (!this.type.accept(gov.first().toString()) || !gov.second().equals(l2)) continue;
                return true;
            }
            usedNodes.add(node);
            for (Pair<GrammaticalRelation, IndexedWord> gov : govs) {
                if (usedNodes.contains(gov.second()) || !this.satisfyHelper(gov.second(), l2, sg, usedNodes)) continue;
                return true;
            }
            return false;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, final SemanticGraph sg) {
            return new SearchNodeIterator(){
                Stack<IndexedWord> searchStack;
                Set<IndexedWord> searchedNodes;
                Set<IndexedWord> matchedNodes;
                Iterator<SemanticGraphEdge> neighborIterator;

                @Override
                public void initialize() {
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    this.neighborIterator = null;
                    this.searchedNodes = Generics.newIdentityHashSet();
                    this.matchedNodes = Generics.newIdentityHashSet();
                    this.searchStack = Generics.newStack();
                    this.searchStack.push(node);
                    this.advance();
                }

                @Override
                void advance() {
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    while (!this.searchStack.isEmpty()) {
                        if (this.neighborIterator == null || !this.neighborIterator.hasNext()) {
                            IndexedWord search = this.searchStack.pop();
                            this.neighborIterator = GRANDSOMETHING.this.neighborIterator(sg, search);
                        }
                        while (this.neighborIterator.hasNext()) {
                            SemanticGraphEdge edge = this.neighborIterator.next();
                            IndexedWord otherEnd = GRANDSOMETHING.this.followEdge(edge);
                            if (!this.searchedNodes.contains(otherEnd)) {
                                this.searchStack.push(otherEnd);
                                this.searchedNodes.add(otherEnd);
                            }
                            if (!GRANDSOMETHING.this.type.accept(edge.getRelation().toString()) || this.matchedNodes.contains(otherEnd)) continue;
                            this.matchedNodes.add(otherEnd);
                            this.next = otherEnd;
                            this.relation = edge.getRelation().toString();
                            return;
                        }
                    }
                    this.next = null;
                }
            };
        }
    }

    private static class LIMITED_GRANDPARENT
    extends GraphRelation {
        final int startDepth;
        final int endDepth;
        private static final long serialVersionUID = 1L;

        LIMITED_GRANDPARENT(String reln, String name, int startDepth, int endDepth) {
            super(startDepth + "," + endDepth + ">>", reln, name);
            this.startDepth = startDepth;
            this.endDepth = endDepth;
        }

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            if (l1.equals(IndexedWord.NO_WORD) || l2.equals(IndexedWord.NO_WORD)) {
                return false;
            }
            ArrayList<Set<IndexedWord>> usedNodes = new ArrayList<Set<IndexedWord>>();
            for (int i = 0; i <= this.endDepth; ++i) {
                usedNodes.add(Generics.newIdentityHashSet());
            }
            return l1 != l2 && this.satisfyHelper(l1, l2, sg, 0, usedNodes);
        }

        private boolean satisfyHelper(IndexedWord parent, IndexedWord l2, SemanticGraph sg, int depth, List<Set<IndexedWord>> usedNodes) {
            List<Pair<GrammaticalRelation, IndexedWord>> deps = sg.childPairs(parent);
            if (depth + 1 > this.endDepth) {
                return false;
            }
            if (depth + 1 >= this.startDepth) {
                for (Pair<GrammaticalRelation, IndexedWord> dep : deps) {
                    if (!this.type.accept(dep.first().toString()) || !dep.second().equals(l2)) continue;
                    return true;
                }
            }
            usedNodes.get(depth).add(parent);
            for (Pair<GrammaticalRelation, IndexedWord> dep : deps) {
                if (usedNodes.size() >= depth + 1 && usedNodes.get(depth + 1).contains(dep.second()) || !this.satisfyHelper(dep.second(), l2, sg, depth + 1, usedNodes)) continue;
                return true;
            }
            return false;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, final SemanticGraph sg) {
            return new SearchNodeIterator(){
                List<Stack<Pair<GrammaticalRelation, IndexedWord>>> searchStack;
                List<Set<IndexedWord>> seenNodes;
                Set<IndexedWord> returnedNodes;
                int currentDepth;

                @Override
                public void initialize() {
                    int i;
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    this.searchStack = Generics.newArrayList();
                    for (i = 0; i <= LIMITED_GRANDPARENT.this.endDepth; ++i) {
                        this.searchStack.add(new Stack());
                    }
                    this.seenNodes = new ArrayList<Set<IndexedWord>>();
                    for (i = 0; i <= LIMITED_GRANDPARENT.this.endDepth; ++i) {
                        this.seenNodes.add(Generics.newIdentityHashSet());
                    }
                    this.returnedNodes = Generics.newIdentityHashSet();
                    this.currentDepth = 1;
                    List<Pair<GrammaticalRelation, IndexedWord>> children = sg.childPairs(node);
                    for (int i2 = children.size() - 1; i2 >= 0; --i2) {
                        this.searchStack.get(1).push(children.get(i2));
                    }
                    if (!this.searchStack.get(1).isEmpty()) {
                        this.advance();
                    }
                }

                @Override
                void advance() {
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    while (this.currentDepth <= LIMITED_GRANDPARENT.this.endDepth) {
                        Set<IndexedWord> nextSeen;
                        Stack<Pair<GrammaticalRelation, IndexedWord>> nextStack;
                        Stack<Pair<GrammaticalRelation, IndexedWord>> thisStack = this.searchStack.get(this.currentDepth);
                        Set<IndexedWord> thisSeen = this.seenNodes.get(this.currentDepth);
                        if (this.currentDepth < LIMITED_GRANDPARENT.this.endDepth) {
                            nextStack = this.searchStack.get(this.currentDepth + 1);
                            nextSeen = this.seenNodes.get(this.currentDepth + 1);
                        } else {
                            nextStack = null;
                            nextSeen = null;
                        }
                        while (!thisStack.isEmpty()) {
                            Pair<GrammaticalRelation, IndexedWord> nextPair = thisStack.pop();
                            if (thisSeen.contains(nextPair.second())) continue;
                            thisSeen.add(nextPair.second());
                            List<Pair<GrammaticalRelation, IndexedWord>> children = sg.childPairs(nextPair.second());
                            for (int i = children.size() - 1; i >= 0; --i) {
                                if (nextSeen == null || nextSeen.contains(children.get(i).second())) continue;
                                nextStack.push(children.get(i));
                            }
                            if (this.currentDepth < LIMITED_GRANDPARENT.this.startDepth || !LIMITED_GRANDPARENT.this.type.accept(nextPair.first().toString()) || this.returnedNodes.contains(nextPair.second())) continue;
                            this.next = nextPair.second();
                            this.relation = nextPair.first().toString();
                            this.returnedNodes.add(nextPair.second());
                            return;
                        }
                        ++this.currentDepth;
                    }
                    this.next = null;
                }
            };
        }
    }

    private static class DEPENDENT
    extends GraphRelation {
        private static final long serialVersionUID = -5115389883698108694L;

        DEPENDENT(String reln, String name) {
            super("<", reln, name);
        }

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            if (l1.equals(IndexedWord.NO_WORD) || l2.equals(IndexedWord.NO_WORD)) {
                return false;
            }
            List<Pair<GrammaticalRelation, IndexedWord>> govs = sg.parentPairs(l1);
            for (Pair<GrammaticalRelation, IndexedWord> gov : govs) {
                if (!this.type.accept(gov.first().toString()) || !gov.second().equals(l2)) continue;
                return true;
            }
            return false;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, final SemanticGraph sg) {
            return new SearchNodeIterator(){
                int nextNum;

                @Override
                public void advance() {
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    List<Pair<GrammaticalRelation, IndexedWord>> govs = sg.parentPairs(node);
                    while (this.nextNum < govs.size() && !DEPENDENT.this.type.accept(govs.get(this.nextNum).first().toString())) {
                        ++this.nextNum;
                    }
                    if (this.nextNum < govs.size()) {
                        this.next = govs.get(this.nextNum).second();
                        this.relation = govs.get(this.nextNum).first().toString();
                        ++this.nextNum;
                    } else {
                        this.next = null;
                    }
                }
            };
        }
    }

    private static class GOVERNER
    extends GraphRelation {
        private static final long serialVersionUID = -7003148918274183951L;

        GOVERNER(String reln, String name) {
            super(">", reln, name);
        }

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            List<Pair<GrammaticalRelation, IndexedWord>> deps = sg.childPairs(l1);
            for (Pair<GrammaticalRelation, IndexedWord> dep : deps) {
                if (!this.type.accept(dep.first().toString()) || !dep.second().equals(l2)) continue;
                return true;
            }
            return false;
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, final SemanticGraph sg) {
            return new SearchNodeIterator(){
                Iterator<SemanticGraphEdge> iterator;

                @Override
                public void advance() {
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                        return;
                    }
                    if (this.iterator == null) {
                        this.iterator = sg.outgoingEdgeIterator(node);
                    }
                    while (this.iterator.hasNext()) {
                        SemanticGraphEdge edge = this.iterator.next();
                        this.relation = edge.getRelation().toString();
                        if (!GOVERNER.this.type.accept(this.relation)) continue;
                        this.next = edge.getTarget();
                        return;
                    }
                    this.next = null;
                }
            };
        }
    }

    static class ALIGNMENT
    extends GraphRelation {
        private Alignment alignment;
        private boolean hypToText = true;
        private static final long serialVersionUID = -2936526066368043778L;

        ALIGNMENT() {
            super("@", "");
        }

        void setAlignment(Alignment alignment, boolean hypToText, SearchNodeIterator itr) {
            this.alignment = alignment;
            this.hypToText = hypToText;
            itr.advance();
        }

        @Override
        boolean satisfies(IndexedWord l1, IndexedWord l2, SemanticGraph sg) {
            if (this.alignment == null) {
                return false;
            }
            if (this.hypToText) {
                return this.alignment.getMap().get(l1).equals(l2);
            }
            return this.alignment.getMap().get(l2).equals(l1);
        }

        @Override
        Iterator<IndexedWord> searchNodeIterator(final IndexedWord node, SemanticGraph sg) {
            return new SearchNodeIterator(){
                boolean foundOnce = false;
                int nextNum;

                @Override
                public void initialize() {
                }

                @Override
                public void advance() {
                    if (ALIGNMENT.this.alignment == null) {
                        return;
                    }
                    if (node.equals(IndexedWord.NO_WORD)) {
                        this.next = null;
                    }
                    if (ALIGNMENT.this.hypToText) {
                        if (!this.foundOnce) {
                            this.next = ALIGNMENT.this.alignment.getMap().get(node);
                            this.foundOnce = true;
                        } else {
                            this.next = null;
                        }
                    } else {
                        int num = 0;
                        for (Map.Entry<IndexedWord, IndexedWord> pair : ALIGNMENT.this.alignment.getMap().entrySet()) {
                            if (!pair.getValue().equals(node)) continue;
                            if (this.nextNum == num) {
                                this.next = pair.getKey();
                                ++this.nextNum;
                                return;
                            }
                            ++num;
                        }
                        this.next = null;
                    }
                }
            };
        }
    }
}

