theory question_17_10
imports Main

begin

typedecl entity
typedecl event
typedecl moon

consts
  Telescope :: "entity ⇒ bool"
  Useful :: "entity ⇒ event ⇒ bool"
  Surface :: "moon ⇒ entity ⇒ bool"
  Moon :: "entity ⇒ bool"
  Observe :: "event ⇒ entity ⇒ bool"
  CelestialObject :: "entity ⇒ bool"
  GatherInformation :: "event ⇒ bool"
  Determine :: "event ⇒ moon ⇒ entity ⇒ bool"
  RequireInformation :: "event ⇒ entity ⇒ bool"

theorem hypothesis:
  assumes asm: "Telescope t ∧ Useful t u ∧ Observe u co ∧ Determine d m s ∧ RequireInformation d  Surface m s  ∧ u < d"
  (* Hypothesis: Using a telescope to determine what is on the surface of the moon is useful, and that this determination event happens after the telescope use event. *)
  shows "GatherInformation u"
proof -
  have 1: "CelestialObject co" using asm(3) by (simp add: Observe_def)
  have 2: "moon m" using asm(4) by (simp add: Determine_def)
  have 3: "Surface m s" using 2 by simp
  have 4: "GatherInformation u" using asm(1) asm(2) asm(3) asm(5) 1 2 3 by (simp add: Useful_def Telescope_def Observe_def RequireInformation_def)
  then show ?thesis using 4 by blast
qed

end
