theory question_77_0

imports Main

begin

typedecl entity

consts
  Mollusks :: "entity ⇒ bool"
  Shell :: "entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"
  Mussels :: "entity ⇒ bool"
  BivalveMollusks :: "entity ⇒ bool"

(* Explanation 1: Most mollusks have shells. *)
axiomatization where
  explanation_1: "∀x. Mollusks x ⟶ (∃y. Shell y ∧ Has x y)"

(* Explanation 2: Mussels are bivalve mollusks. *)
axiomatization where
  explanation_2: "∀x. Mussels x ⟶ BivalveMollusks x"

theorem hypothesis:
  assumes asm: "Mussels x"
  (* Hypothesis: Mussels have a shell. *)
  shows "Shell x"
proof -
  from asm have "Mussels x" by simp
  then have "BivalveMollusks x" using explanation_2 by blast
  then have "Mollusks x" by simp
  then have "∃y. Shell y ∧ Has x y" using explanation_1 by blast
  then obtain y where "Shell y ∧ Has x y" by force
  then have "Shell x" using `Shell y` and `Has x y` by blast
  then show ?thesis by simp
qed

end
