theory question_45_0
imports Main

begin

typedecl entity
typedecl event

consts
  Faulting :: "entity ⇒ bool"
  Rock :: "entity ⇒ bool"
  Crust :: "entity ⇒ bool"
  Earth :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Earthquakes :: "entity ⇒ bool"
  FaultZones :: "entity ⇒ bool"
  Plates :: "entity ⇒ bool"
  Slide :: "event ⇒ bool"
  Collide :: "event ⇒ bool"

(* Explanation 1: Faulting of rock in Earth's crust causes earthquakes. *)
axiomatization where
  explanation_1: "∀x y e. Faulting x ∧ Rock y ∧ Crust z ∧ Earth e ∧ Agent e x ⟶ Earthquakes y"

(* Explanation 2: Fault zones are plates in the earth that slide and collide. *)
axiomatization where
  explanation_2: "∀x y. FaultZones x ⟶ Plates x ∧ Earth y ∧ (∃e. Slide e ∧ Agent e x) ∧ (∃e. Collide e ∧ Agent e x)"

theorem hypothesis:
  assumes asm: "Plates x ∧ Earth y ∧ Collide e ∧ Agent e x"
  (* Hypothesis: Plates in the earth collide which causes earthquakes. *)
  shows "∃x y. Plates x ∧ Earth y ∧ Earthquakes y"
proof -
  from asm have "Plates x" by simp
  then have "FaultZones x" using explanation_2 by blast
  then have "Earthquakes x" using explanation_1 by blast
  then show "∃x y. Plates x ∧ Earth y ∧ Earthquakes y" using asm by blast
qed

end
