theory question_98_0
imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Pool :: "entity ⇒ bool"
  Jumping :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  YoungMan :: "entity ⇒ bool"
  Goggles :: "entity ⇒ bool"
  Wearing :: "event ⇒ bool"
  Splashing :: "event ⇒ bool"
  Water :: "entity ⇒ bool"
  In :: "entity ⇒ entity ⇒ bool"
  In_water :: "event ⇒ entity ⇒ bool" (* new const *)

(* Explanation: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
axiomatization where
  explanation_1: "∀x y z e1 e2.
    YoungMan x ∧ Man x ∧ Goggles y ∧ Pool z ∧ Wearing e1 ∧ Agent e1 x ∧ Patient e1 y ∧
    Jumping e2 ∧ Agent e2 x ∧ Patient e2 z ∧ Splashing e2 ∧ In_water e2 z ∧
    In Water z ⟶ (∃x e. Man x ∧ Pool some-pool ∧ Jumping e ∧ Agent e x ∧ In_water e z)"

theorem hypothesis:
  (* Premise: A young man wearing goggles, is jumping out of a pool, splashing water everywhere. *)
  assumes asm: "YoungMan x ∧ Man x ∧ Goggles y ∧ Pool z ∧ Wearing e1 ∧ Agent e1 x ∧ Patient e1 y ∧ Jumping e2 ∧ Agent e2 x ∧ Patient e2 z ∧ Splashing e2 ∧ Patient e2  In_water e2  ∧ In Water z"
  (* Hypothesis: Man jumping out of a pool. *)
  shows "∃x e. Man x ∧ Pool some-pool ∧ Jumping e ∧ Agent e x ∧ In_water e z"
proof -
  from asm have "Man x ∧ Pool z ∧ Jumping e2 ∧ Agent e2 x ∧ In_water e2 z" by blast
  then show ?thesis using asm by blast
qed

end
