theory question_86_6
imports Main

begin

typedecl entity
typedecl event

consts
  Conversing :: "entity ⇒ bool"
  Talking :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Table :: "entity ⇒ bool"
  Drinks :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"
  With :: "entity ⇒ entity ⇒ bool"

(* Explanation: If an entity is conversing, then they are talking. *)
axiomatization where
  explanation: "∀x. Conversing x ⟶ Talking x"

theorem hypothesis:
  (* Premise: There are three woman conversing at a table with drinks. *)
  assumes asm: "Woman x1 ∧ Woman x2 ∧ Woman x3 ∧ Conversing x1 ∧ Conversing x2 ∧ Conversing x3 ∧ Table t ∧ Drinks d ∧ At x1 t ∧ At x2 t ∧ At x3 t ∧ With x1 d ∧ With x2 d ∧ With x3 d"
  (* Hypothesis: Women are talking. *)
  shows "∃x. Woman x ∧ Talking x"
proof -
  from asm have "Conversing x1" "Conversing x2" "Conversing x3" by blast+
  with explanation have "Talking x1" "Talking x2" "Talking x3" by blast+
  then show "∃x. Woman x ∧ Talking x" using asm by blast
qed

end
