theory question_100_7

imports Main

begin

typedecl entity

consts
  YoungBoy :: "entity ⇒ bool"
  Child :: "entity ⇒ bool"
  PlayingInSprinklers :: "entity ⇒ bool"
  InWater :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"

(* Explanation 1: Every young boy is a child. *)
axiomatization where
  explanation_1: "∀x. YoungBoy x ⟶ Child x"

(* Explanation 2: Playing in sprinklers implies being in water. *)
axiomatization where
  explanation_2: "PlayingInSprinklers x ⟶ InWater x"

(* Explanation 3: Playing in sprinklers implies being outside. *)
axiomatization where
  explanation_3: "PlayingInSprinklers x ⟶ Outside x"

theorem hypothesis:
  (* Premise: There exists a young boy in a swimsuit who plays in sprinklers and is outside. *)
  assumes asm: "YoungBoy x ∧ Swimsuit x ∧ PlayingInSprinklers x ∧ Outside x"
  (* Hypothesis: There exists a child who is outside and in water. *)
  shows "∃x. Child x ∧ Outside x ∧ InWater x"
proof -
  from asm have "YoungBoy x" by blast
  then have "Child x" using explanation_1 by blast
  from asm have "PlayingInSprinklers x" by blast
  then have "InWater x" using explanation_2 by blast
  from asm have "Outside x" by blast
  then show ?thesis using `Child x` `InWater x` `Outside x` by blast
qed

end
