theory question_99_10

imports Main

begin

typedecl entity
typedecl event

consts
 People :: "entity ⇒ bool"
 Street :: "entity ⇒ bool"
 Running :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 On :: "event ⇒ entity ⇒ bool"

(* Explanation 1: People are running on the street. *)
axiomatization where
 explanation_1: "∀x y e. People x ∧ Street y ∧ Running e ∧ Agent e x ∧ On e y"

theorem hypothesis:
 (* Premise: There exists a busy city street, winter, and people walking. *)
 assumes asm: "People x  ∧ BusyCityStreet y  ∧ Winter z  ∧ Walking e  ∧ Agent e  x  ∧ Down e  y  ∧ In e  z "
 (* Hypothesis: A street has a lot of people. *)
 shows "∃x. Street x  ∧ ALotOfPeople x "
proof -
 from asm have "People x ∧ BusyCityStreet y ∧ Winter z ∧ Walking e ∧ Agent e x ∧ Down e y ∧ In e z" by blast
 then have "∃x. Street x ∧ ALotOfPeople x" using explanation_1 by blast
 then show ?thesis using `People x` `BusyCityStreet y` `Winter z` `Walking e` `Agent e x` `Down e y` `In e z` by blast
qed

end
