theory question_67_0

imports Main

begin

typedecl entity
typedecl event

consts
 Male :: "entity ⇒ bool"
 Boat :: "entity ⇒ bool"
 Sitting :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 RiverBoatTour :: "event ⇒ bool"
 BeingOnABoat :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: If two males are sitting together on a boat, they are on a river boat tour. *)
axiomatization where
 explanation_1: "∀x y e. Sitting e ∧ Male x ∧ Male y ∧ Boat e ⟶ RiverBoatTour e"

theorem hypothesis:
 (* Premise: Two older males sitting together on a river boat tour. *)
 assumes asm: "Male x  ∧ Male y  ∧ RiverBoatTour z  ∧ Sitting e  ∧ Agent e  x  ∧ Agent e  y  ∧ In e  z "
 (* Hypothesis: Two males sitting together on a boat. *)
 shows "∃x y e. Male x  ∧ Male y  ∧ Boat e  ∧ Sitting e  ∧ Agent e  x  ∧ Agent e  y "
proof -
 from asm have "Male x ∧ Male y ∧ RiverBoatTour z ∧ Sitting e ∧ Agent e x ∧ Agent e y ∧ In e z" by blast
 then have "Male x ∧ Male y ∧ Boat e ∧ Sitting e ∧ Agent e x ∧ Agent e y" using explanation_1 by blast
 then show ?thesis using `Male x` `Male y` `Boat e` `Sitting e` `Agent e x` `Agent e y` by blast
qed

end
