theory question_45_3

imports Main

begin

typedecl entity
typedecl event

consts
  Woman :: "entity ⇒ bool"
  BlackClothing :: "entity ⇒ bool"
  Barefoot :: "entity ⇒ bool"
  Running :: "event ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  NextTo :: "entity ⇒ entity ⇒ bool"
  FemaleRunner :: "entity ⇒ bool"
  Down :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A person running barefoot is outdoors. *)
axiomatization where
  explanation_1: "∀x. Person x ∧ Barefoot x ∧ Running x ⟶ Outdoors x"

(* Explanation 2: A person next to two people on bicycles and a female runner is outdoors. *)
axiomatization where
  explanation_2: "∀x y z e. Person x ∧ Bicycles y ∧ FemaleRunner z ∧ Running e ⟶ Outdoors x ∧ NextTo x y ∧ NextTo x z"

(* Explanation 3: A woman running down the street barefoot next to two people on bicycles and a female runner is outdoors. *)
axiomatization where
  explanation_3: "∃x y z e. Woman x ∧ Barefoot x ∧ Running e ∧ Agent e x ∧ Down e y ∧ NextTo x y ∧ NextTo x z ∧ FemaleRunner z"

theorem hypothesis:
  (* Premise: A woman in black clothing runs down the street barefoot next to two people on bicycles and a female runner. *)
  assumes asm: "Woman x ∧ BlackClothing x ∧ Barefoot x ∧ Running e ∧ Agent e x ∧ Down e y ∧ NextTo x y ∧ NextTo x z ∧ FemaleRunner z"
  (* Hypothesis: The woman is outdoors. *)
  shows "∃x e. Woman x ∧ Outdoors e ∧ Running e ∧ Agent e x"
proof -
  from premise have "Woman x" by blast
  from explanation_3 have "Outdoors x" by blast
  show ?thesis using `Woman x` `Outdoors x` by blast
qed

end
