theory question_81_7

imports Main

begin

typedecl entity
typedecl event

consts
  BottleneckEffect :: "entity ⇒ bool"
  Population :: "entity ⇒ bool"
  Event :: "entity ⇒ bool"
  Occurs :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  GetsSmaller :: "event ⇒ bool"
  DueTo :: "event ⇒ entity ⇒ bool"
  ExternalMigration :: "entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Triggers :: "event ⇒ bool"

(* Explanation 1: Bottleneck effect occurs when a population suddenly gets much smaller due to an event. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. BottleneckEffect x ∧ Population y ∧ Event z ∧ Occurs e1 ∧ Agent e1 x ∧ GetsSmaller e2 ∧ Agent e2 y ∧ DueTo e2 z"

(* Explanation 2: External migration is an event that can cause a population to suddenly get much smaller. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. ExternalMigration x ∧ Event x ∧ Population y ∧ GetsSmaller e1 ∧ Agent e1 y ∧ Cause e2 ∧ Agent e2 x ∧ Patient e2 y"

(* Explanation 3: When external migration occurs, it triggers the bottleneck effect. *)
axiomatization where
  explanation_3: "∀x y e1 e2. ExternalMigration x ∧ BottleneckEffect y ∧ Occurs e1 ∧ Agent e1 x ⟶ Triggers e2 ∧ Agent e2 x ∧ Patient e2 y"

theorem hypothesis:
  assumes asm: "BottleneckEffect x ∧ ExternalMigration y"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃x y e. BottleneckEffect x ∧ ExternalMigration y ∧ Occurs e ∧ Agent e x ∧ Patient e y"
proof -
  from asm have "BottleneckEffect x ∧ ExternalMigration y" by simp
  then obtain e1 where e1: "Occurs e1 ∧ Agent e1 x" using explanation_1 by blast
  then have "ExternalMigration y" using explanation_2 by blast
  then have "Triggers e2 ∧ Agent e2 x ∧ Patient e2 y" using explanation_3 by blast
  have conclusion: "Occurs e1 ∧ Agent e1 x ∧ Patient e1 y" using e1 by simp
  show ?thesis using asm conclusion `ExternalMigration y` by blast
qed

end
