theory question_70_1

imports Main

begin

typedecl entity
typedecl event

consts
  Observations :: "entity ⇒ bool"
  Evidence :: "entity ⇒ bool"
  ScientificTheory :: "entity ⇒ bool"

(* Explanation 1: Observations(x) ⟶ Evidence(x) ∧ ScientificTheory(x) *)
axiomatization where
  explanation_1: "∀x. Observations x ⟶ Evidence x ∧ ScientificTheory x"

theorem hypothesis:
  assumes asm: "Observations x"
  (* Hypothesis: Observations serve as evidence for a scientific theory. *)
  shows "∃x. Evidence x ∧ ScientificTheory x"
proof -
  from asm have "Observations x" by simp
  then have "Evidence x ∧ ScientificTheory x" using explanation_1 by blast
  then show ?thesis using `Evidence x` `ScientificTheory x` by blast
qed

end
