theory question_87_1

imports Main

begin

typedecl entity
typedecl event

consts
  Tunicates :: "entity ⇒ bool"
  ReproduceSexually :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Bulbs :: "entity ⇒ bool"
  Tunicate :: "entity ⇒ bool"
  NonTunicate :: "entity ⇒ bool"
  Classified :: "event ⇒ bool"

(* Explanation 1: Tunicates reproduce sexually. *)
axiomatization where
  explanation_1: "∀x e. Tunicates x ∧ ReproduceSexually e ∧ Agent e x"

(* Explanation 2: Bulbs are classified as tunicate or non-tunicate. *)
axiomatization where
  explanation_2: "∀x. Bulbs x ⟶ (Tunicate x ∨ NonTunicate x)"

(* Explanation 3: If bulbs are classified as tunicates, then they reproduce sexually. *)
axiomatization where
  explanation_3: "∀x e1 e2. Bulbs x ∧ Tunicate x ⟶ (Classified e1 ∧ Agent e1 x ⟶ ReproduceSexually e2 ∧ Agent e2 x)"

theorem hypothesis:
  assumes asm: "Bulbs x"
  (* Hypothesis: Bulbs reproduce sexually. *)
  shows "∃x e. Bulbs x ∧ ReproduceSexually e ∧ Agent e x"
proof -
  from asm have "Bulbs x" by simp
  then have "Tunicate x ∨ NonTunicate x" using explanation_2 by blast
  then obtain e where e: "Classified e ∧ Agent e x ⟶ ReproduceSexually e' ∧ Agent e' x" using explanation_3 by blast
  then have "Tunicates x" using e explanation_1 by blast
  have conclusion: "Classified e ∧ Agent e x ⟶ ReproduceSexually e' ∧ Agent e' x" using e by simp
  show ?thesis using asm conclusion `Tunicates x` by blast
qed

end
