theory question_85_3

imports Main

begin

typedecl entity
typedecl event

consts
  PacinianCorpuscles :: "entity ⇒ bool"
  PressureReceptors :: "entity ⇒ bool"
  Skin :: "entity ⇒ bool"
  Found :: "event ⇒ bool"
  MainlyIn :: "event ⇒ entity ⇒ bool"
  TypeOf :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Pacinian corpuscles are found mainly in the skin. *)
axiomatization where
  explanation_1: "∀x y. PacinianCorpuscles x ∧ Skin y ⟶ (∃e. Found e ∧ MainlyIn e y ∧ TypeOf e x)"

(* Explanation 2: Pacinian corpuscles, as pressure receptors, are specifically located mainly in the skin. *)
axiomatization where
  explanation_2: "∀x y z e. PacinianCorpuscles x ∧ PressureReceptors z ∧ Skin y ⟶ Located e ∧ MainlyIn e y ∧ Specifically e z"

theorem hypothesis:
  assumes asm: "PacinianCorpuscles x ∧ Skin y"
  (* Hypothesis: Pacinian corpuscles are found mainly in the skin. *)
  shows "∃z e. Found e ∧ MainlyIn e y ∧ TypeOf e x"
proof -
  from asm have "PacinianCorpuscles x ∧ Skin y" by simp
  then obtain e where e: "Found e ∧ MainlyIn e y ∧ TypeOf e x" using explanation_1 by blast
  then have "PressureReceptors z" using explanation_2 by blast
  have conclusion: "Found e ∧ MainlyIn e y ∧ TypeOf e x" using e by simp
  show ?thesis using conclusion by blast
qed

end
