theory question_76_0

imports Main

begin

typedecl entity
typedecl event

consts
  Animals :: "entity ⇒ bool"
  Plants :: "entity ⇒ bool"
  Die :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Decomposers :: "entity ⇒ bool"
  Complete :: "event ⇒ bool"
  Cycle :: "entity ⇒ bool"
  TooHot :: "entity ⇒ bool"
  Organism :: "entity ⇒ bool"
  
(* Explanation 1: When the animals and plants die, the decomposers complete the cycle. *)
axiomatization where
  explanation_1: "(∃e1 x. Animals x ∧ Plants x ∧ Die e1 ∧ Agent e1 x) ⟶ (∃e2 y. Decomposers y ∧ Complete e2 ∧ Agent e2 y ∧ Cycle y)"

theorem hypothesis:
  assumes asm: "Organism x ∧ Becomes e1 ∧ Agent e1 x ∧ TooHot x"
  (* Hypothesis: If an organism becomes too hot, then decomposers complete their cycle. *)
  shows "∃e2 y. Decomposers y ∧ Complete e2 ∧ Agent e2 y ∧ Cycle y"
proof -
  obtain e1 x where e1_x: "Organism x ∧ Becomes e1 ∧ Agent e1 x ∧ TooHot x" using asm by blast
  from e1_x have "Animals x ∧ Plants x ∧ Die e1 ∧ Agent e1 x" by blast
  then obtain e2 y where e2_y: "Decomposers y ∧ Complete e2 ∧ Agent e2 y ∧ Cycle y" using explanation_1 by blast
  show ?thesis using e2_y by blast
qed

end
