theory question_71_0
imports Main

begin

typedecl entity
typedecl event

consts
  Chloroplasts :: "entity ⇒ bool"
  ContainsGreenPigment :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  Lack :: "entity ⇒ entity ⇒ bool"
  Chlorophyll :: "entity ⇒ bool"

(* Explanation 1: Chloroplasts contain the green pigment chlorophyll. *)
axiomatization where
  explanation_1: "∀x. Chloroplasts x ⟶ ContainsGreenPigment x"

(* Explanation 2: Animals lack chloroplasts. *)
axiomatization where
  explanation_2: "∀x e. Animals x ∧ Chloroplasts e ∧ Lack e x"

theorem hypothesis:
  assumes asm: "Animals x"
  (* Hypothesis: Animals lack chlorophyll. *)
  shows "∃x e. Animals x ∧ Chlorophyll e ∧ Lack e x"
proof -
  from asm have "Animals x" by simp
  then obtain e where e: "Chloroplasts e ∧ Lack e x" using explanation_2 by blast
  then have "Chlorophyll e" using explanation_1 by blast
  have conclusion: "Chloroplasts e ∧ Lack e x" using e by simp
  show ?thesis using asm conclusion `Chlorophyll e` by blast
qed

end
