# Installation

## Python Environment


```
conda create -n visarg python=3.9 -y

conda activate visarg
# After installing pytorch,

pip install -r requirements.txt
pip install -e .

# To use flash attention
pip install packaging
pip install flash-attn
```

## Third Party

```
# If you need it.
cd third_party
git clone https://github.com/allenai/unified-io-2.pytorch.git
git clone https://github.com/MasterBin-IIAU/UNINEXT.git
git clone https://github.com/youtubevos/cocoapi.git

cd src/visarg/others/pycocoevalcap
git clone https://github.com/salaniz/pycocoevalcap.git

cd src/visarg/models/grounding/LISA
git clone https://github.com/dvlab-research/LISA.git
git clone https://github.com/IDEA-Research/GroundingDINO.git
```

<br></br>

# Experiment Script
## Main Exp
`python ./src/visarg/main.py`
## with arguments
- task : int, options-[1, 2, 3]
### Common
- data : str, options-[cartoon, social, ads, new_cartoon] default: llava

### Task1
- ground_model : str, model_name default: llava
- task1_result_path : str, result path for task1

### Task2
Refer to negative_set.json.

### Task3
- deduct_model : str, model_name default: llava
- text2con : store_ture, use llm to deduct
- out_path : str, result path default: ./results/task3
- prompting : int, prompting mode options-[0, 1, 2, 3, 4]
- prompt_style : int, prompting style options-[0, 1, 2, 3, 4]
- without_img : store_true, use vlm to deduct with out img
- few_shot : int, few-shot options-[0, 1, 2, 3]
- few_shot_with_images : store_true, few-shot with image
---
Example scripts
```
# Task 1
python ./src/visarg/main.py --task 1 --data cartoon --ground_model ofa

# Task 3 (Deduction of Conclusion) with LLaVANeXT on cartoon dataset (condition: Image, VP, CP, Tree)
python ./src/visarg/main.py --task 3 --data cartoon --deduct_model llavanext --prompting 4
```
---
## Evaluation
### Task 3 Evaluation
`python ./src/visarg/others/eval_con.py`
## with arguments
- gts_path : str, gts path
- res_path : str, results of model path
- metrics : list[str], evaluation metrics options-[bleu:n, cider, rouge, spice, bert]
---

Example scripts
```
# Evaluating on LLaVANeXT's respoonse from cartoon.
python ./src/visarg/others/eval_con --gts_path ./results/task3/llavanext_4_cartoon_gts.json --res_path ./results/task3/llavanext_4_cartoon_res.json --metrics bleu:4 rouge cider bert
```