import sys
import os
import re
module_path = os.path.abspath(os.path.join('..'))
if module_path not in sys.path:
    sys.path.append(module_path)
from utils.api_utils import get_apis
from utils.chroma_utils import index_chroma
from utils.graphql_utils import get_modified_schema_tmdb, get_modified_schema_spotify
from utils.nlp_utils import get_named_entity
from utils.api_utils import get_spotify_access_token
import json
import shutil
import subprocess
import os
import json
import logging
import urllib
from tqdm import tqdm


logger = logging.getLogger()


from dotenv import load_dotenv
load_dotenv()

my_env = os.environ.copy()

spec_path = "openapi_specs/spotify_oas.json"
access_token = get_spotify_access_token(spec_path)
# access_token = "BQDqp-X9LPD38WEDGy6Up97-WLbqgB21-XSSwktVpBwEJXNTNahlZsvcP0IdzW895xE3u2ckFBZc-hWYMo5fUKuhqS__4bYBCUVtrfX9zEGZZY6N5LjzIW7E2lsrKM6CZyjkn_AOo6PRfPGLhgfjJdkO4oFWyrnI84IY6tZh1DuZ8SQaOsYbH34jtnq7l3sbUExbHVK0YLzyKwz7kSlbe1JqXXLzU3T5r4NmHfszlNVsLAT3CAD8D7dHpw2YCE8w48m_x0Gxlb--LdWE-kLtmsjP5Gtep1W0jVU787k7s7oGSNSteLdv2uzbNi2urwx6NUcrzHcyJ29t3mFCbup-"
print("Spotify access token:\n"+access_token)

my_env["spotify_access_token"] = access_token

path = "openapi_specs/tmdb_oas.json"
with open(path) as f:
    tmdb_spec = json.load(f)

path = "openapi_specs/spotify_oas.json"
with open(path) as f:
    spotify_spec = json.load(f)


tmdb_paths = {}
for p in tmdb_spec['paths']:
    if 'get' in tmdb_spec['paths'][p]:
        if 'description' in tmdb_spec['paths'][p]['get']:
            tmdb_paths[p] = tmdb_spec['paths'][p]['get']['description']
        elif 'summary' in tmdb_spec['paths'][p]['get']:
            tmdb_paths[p] = tmdb_spec['paths'][p]['get']['summary']

spotify_paths = {}
for p in spotify_spec['paths']:
    if 'get' in spotify_spec['paths'][p]:
        if 'description' in spotify_spec['paths'][p]['get']:
            spotify_paths[p] = spotify_spec['paths'][p]['get']['description']
        elif 'summary' in spotify_spec['paths'][p]['get']:
            spotify_paths[p] = spotify_spec['paths'][p]['get']['summary']


with open("datasets/spotify_filtered.json") as f:
    spotify_data = json.load(f)

with open("datasets/tmdb_filtered.json") as f:
    tmdb_data = json.load(f)

# print("Creating spotify schema...")
# i = int(sys.argv[1])
# for obj in tqdm(spotify_data[i-1:i]):
#     shutil.rmtree("spotify_data/stepzen_import/test"+str(i))
#     os.makedirs("spotify_data/stepzen_import/test"+str(i), exist_ok=True)
#     d = {"endpoint": "api/spotify_test"+str(i)}
#     with open("spotify_data/stepzen_import/test"+str(i)+"/stepzen.config.json","w") as f1:
#         json.dump(d, f1, indent=2)

#     f = open("spotify_data/stepzen_import/test"+str(i)+"/import.sh","w")
#     utterance = obj["query"]
#     print("Utterance:", utterance)
#     sol = obj["solution"]
#     apis = []
#     post_apis = []
#     for s in sol:
#         s = s.strip()
#         cmd, api = s.split(" ", 1)
#         if cmd == "GET":
#             apis.append(api)
#         elif cmd == "POST":
#             post_apis.append(api)
    
#     query_string = get_named_entity(utterance)
#     query_string = urllib.parse.quote_plus(query_string)
#     for api in apis:
#         query_name = "GET"+api
#         query_name = query_name.replace("{","_").replace("}","_").replace("/","_").replace("-","_")
#         if not query_name.endswith("_"):
#             prefix = query_name + "_"
#         else:
#             prefix = query_name
#         if "{" in api:
#             path_param = "/v1"+api.replace("{","$").replace("}","")
#         else:
#             path_param = None
#         if "{playlist_id}" in api:
#             api = api.replace("{playlist_id}","7olxsIPAL7TGVN9HC89DNP")
#         if "{user_id}" in api:
#             api = api.replace("{user_id}","31rph2hasdr2pflu7x5sffw4xxgy")
#         if "/artists/{id}" in api:
#             api = api.replace("/artists/{id}","/artists/04gDigrS5kc9YWfZHwBETP")
#         if "/albums/{id}" in api:
#             api = api.replace("/albums/{id}","/albums/6fu8fvc7O4p8Gb8KMTBTUW")
#         if "/tracks/{id}" in api:
#             api = api.replace("/tracks/{id}","/tracks/2MSgFefjK0T7Iwjvr3OKqV")
#         if "/top/{type}" in api and "artist" in utterance:
#             api = api.replace("{type}","artists")
#         if "/top/{type}" in api and ("track" in utterance or "song" in utterance):
#             api = api.replace("{type}","tracks")


        
#         if "/search" in api and "album" in utterance.lower():
#             cmd = f"""stepzen import curl --request GET \\
#         --prefix "{prefix}" \\
#         --query-name "{query_name}" \\
#         --url 'https://api.spotify.com/v1{api}?q={query_string}&type=album' \\
#         -H "Authorization: Bearer $spotify_access_token" \\
#         --header-param 'Authorization: Bearer $spotify_access_token'
#         """
#         elif "/search" in api and ("artist" in utterance.lower() or "follow" in utterance.lower()):
#             cmd = f"""stepzen import curl --request GET \\
#         --prefix "{prefix}" \\
#         --query-name "{query_name}" \\
#         --url 'https://api.spotify.com/v1{api}?q={query_string}&type=artist' \\
#         -H "Authorization: Bearer $spotify_access_token" \\
#         --header-param 'Authorization: Bearer $spotify_access_token'
#         """
#         elif "/search" in api:
#             cmd = f"""stepzen import curl --request GET \\
#         --prefix "{prefix}" \\
#         --query-name "{query_name}" \\
#         --url 'https://api.spotify.com/v1{api}?q={query_string}&type=track' \\
#         -H "Authorization: Bearer $spotify_access_token" \\
#         --header-param 'Authorization: Bearer $spotify_access_token'
#         """
#         elif "/me/following" in api:
#             cmd = f"""stepzen import curl --request GET \\
#         --prefix "{prefix}" \\
#         --query-name "{query_name}" \\
#         --url 'https://api.spotify.com/v1{api}?type=artist' \\
#         -H "Authorization: Bearer $spotify_access_token" \\
#         --header-param 'Authorization: Bearer $spotify_access_token'
#         """
#         elif path_param is not None:
#             cmd = f"""stepzen import curl --request GET \\
#         --prefix "{prefix}" \\
#         --query-name "{query_name}" \\
#         --url 'https://api.spotify.com/v1{api}' \\
#         --path-params '{path_param}' \\
#         -H "Authorization: Bearer $spotify_access_token" \\
#         --header-param 'Authorization: Bearer $spotify_access_token'
#         """
#         else:
#             cmd = f"""stepzen import curl --request GET \\
#         --prefix "{prefix}" \\
#         --query-name "{query_name}" \\
#         --url 'https://api.spotify.com/v1{api}' \\
#         -H "Authorization: Bearer $spotify_access_token" \\
#         --header-param 'Authorization: Bearer $spotify_access_token'
#         """
#         print(cmd, file=f)

#     for api in post_apis:
#         query_name = "POST"+api
#         query_name = query_name.replace("{","_").replace("}","_").replace("/","_").replace("-","_")
#         if not query_name.endswith("_"):
#             prefix = query_name + "_"
#         else:
#             prefix = query_name
#         if "{" in api:
#             path_param = "/v1"+api.replace("{","$").replace("}","")
#         else:
#             path_param = None
#         if "{playlist_id}" in api:
#             api = api.replace("{playlist_id}","7olxsIPAL7TGVN9HC89DNP")
#         if "{user_id}" in api:
#             api = api.replace("{user_id}","31rph2hasdr2pflu7x5sffw4xxgy")
        
#         if "/users/{user_id}/playlists" in api:
#             cmd = f"""stepzen import curl --request POST \\
#         --prefix "{prefix}" \\
#         --query-name "{query_name}" \\
#         --url 'https://api.spotify.com/v1{api}' \\
#         --data '{"name": "New Playlist"}' \\
#         -H "Authorization: Bearer $spotify_access_token" \\
#         --header-param 'Authorization: Bearer $spotify_access_token'
#         """
#             print(cmd, file=f)
    
#     f.close()
#     os.chdir("spotify_data/stepzen_import/test"+str(i))
#     retcode = subprocess.call(['sh', './import.sh'], env=my_env)
#     os.chdir("../../../")
#     i += 1

# quit()
print("Creating tmdb schema...")
i = int(sys.argv[1])
for obj in tqdm(tmdb_data[i-1:i]):
    shutil.rmtree("tmdb_data/stepzen_import/test"+str(i))
    os.makedirs("tmdb_data/stepzen_import/test"+str(i), exist_ok=True)
    d = {"endpoint": "api/tmdb_test"+str(i)}
    with open("tmdb_data/stepzen_import/test"+str(i)+"/stepzen.config.json","w") as f1:
        json.dump(d, f1, indent=2)
    f = open("tmdb_data/stepzen_import/test"+str(i)+"/import.sh","w")
    utterance = obj["query"]
    print("Utterance:", utterance)
    sol = obj["solution"]
    apis = []
    for s in sol:
        s = s.strip()
        cmd, api = s.split(" ", 1)
        if cmd == "GET" and api not in apis:
            apis.append(api)
    
    query_string = get_named_entity(utterance)
    query_string = urllib.parse.quote_plus(query_string)
    for api in apis:
        query_name = "GET"+api
        query_name = query_name.replace("{","_").replace("}","_").replace("/","_")
        if not query_name.endswith("_"):
            prefix = query_name + "_"
        else:
            prefix = query_name
        if "{" in api:
            path_param = "/3"+api.replace("{","$").replace("}","")
        else:
            path_param = None
        if "{person_id}" in api:
            api = api.replace("{person_id}","1")
        if "{movie_id}" in api:
            api = api.replace("{movie_id}","278")
        if "{collection_id}" in api:
            api = api.replace("{collection_id}","10")
        if "{company_id}" in api:
            api = api.replace("{company_id}","1")
        if "{tv_id}" in api:
            api = api.replace("{tv_id}","1418")
        if "{media_type}" in api:
            api = api.replace("{media_type}","movie")
        if "{time_window}" in api:
            api = api.replace("{time_window}","day")
        if "{season_number}" in api:
            api = api.replace("{season_number}","1")
        if "{episode_number}" in api:
            api = api.replace("{episode_number}","1")
        if "{network_id}" in api:
            api = api.replace("{network_id}","49")
        
        if "/search" in api:
            cmd = f"""stepzen import curl --request GET \\
        --prefix "{prefix}" \\
        --query-name "{query_name}" \\
        --url 'https://api.themoviedb.org/3{api}?query={query_string}' \\
        -H "Authorization: Bearer $tmdb_access_token" \\
        --header-param 'Authorization: Bearer $tmdb_access_token'
        """
        elif path_param is not None:
            cmd = f"""stepzen import curl --request GET \\
        --prefix "{prefix}" \\
        --query-name "{query_name}" \\
        --path-params '{path_param}' \\
        --url 'https://api.themoviedb.org/3{api}' \\
        -H "Authorization: Bearer $tmdb_access_token" \\
        --header-param 'Authorization: Bearer $tmdb_access_token'
        """
        else:
            cmd = f"""stepzen import curl --request GET \\
        --prefix "{prefix}" \\
        --query-name "{query_name}" \\
        --url 'https://api.themoviedb.org/3{api}' \\
        -H "Authorization: Bearer $tmdb_access_token" \\
        --header-param 'Authorization: Bearer $tmdb_access_token'
        """
        print(cmd, file=f)
    f.close()
    os.chdir("tmdb_data/stepzen_import/test"+str(i))
    retcode = subprocess.call(['sh', './import.sh'], env=my_env)
    os.chdir("../../../")
    i += 1







