import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import seaborn as sns
from tabularDataImporter import TabularDataImporter
import tensorflow as tf
from typing import List, Dict, Tuple

from tensorflow import keras
from tensorflow.keras import layers
from tensorflow_addons.metrics import RSquare
            


class DNNRegressor:
      def __init__(self, csvfile:str, predictors:List[str], response:List[str])->pd.DataFrame:
        
            self.data:pd.DataFrame = TabularDataImporter(csvfile)
            self.data.preprocess_all()
            self.data.encodeCategorical()

            self.X_train, self.X_test, self.y_train, self.y_test = self.data.split_train_test_set(predictors, response)


            # model
            normalizer = tf.keras.layers.Normalization(axis=-1)
            normalizer.adapt(np.array(self.X_train))
            npdata = np.array(self.X_train)

            if len(predictors) == 0:
                  dim0 = len(self.X_train.columns)
            else:
                  dim0 = len(predictors)

            data_normalizer = layers.Normalization(input_shape=[dim0,], axis=None)
            data_normalizer.adapt(npdata)
            self.model = tf.keras.Sequential([
                  data_normalizer,
                  layers.Dense(64, activation='relu'),
                  layers.Dense(64, activation='relu'),
                  layers.Dense(units=1)
                  ])
            self.model.compile(
                  optimizer=tf.keras.optimizers.Adam(learning_rate=0.001),
                  loss='mean_absolute_error')
                                    
      def toString(self):
            return "DNNRegressor"


      def train(self, epochs:int = 1)->None:

            self.history = self.model.fit(
                  self.X_train,
                  self.y_train,
                  epochs=epochs,
                  verbose=0,
                  validation_split = 0.2)


      def response_predict(self, test_data):
            return  self.model.predict(test_data)



      def analyse_loss(self)->None:
            plt.plot(self.history.history['loss'], label='loss')
            plt.plot(self.history.history['val_loss'], label='val_loss')
            plt.ylim([0, 10])
            plt.xlabel('Epoch')
            plt.ylabel('Error')
            plt.legend()
            plt.grid(True)
            plt.show()


      def evaluate(self):
            

            
            mse = tf.keras.losses.MeanSquaredError()
            y_pred = self.model.predict(self.X_test)
            MSE_val = mse(y_pred, self.y_test).numpy()

            r2 = RSquare()
            r2.update_state(self.y_test, y_pred)
            r2_coeff = r2.result()
            r2_val = r2_coeff.numpy()




            scalar_test_loss = self.model.evaluate(
                  self.X_test,
                  self.y_test, verbose=0)
            return MSE_val, r2_val, scalar_test_loss



# nn1 = DNNRegressor("data.csv", [], ["Beschleunigung"]) # empty predictors means all
# nn1.train(100)
# print(nn1.data)
# nn1.analyse_loss()
# print(nn1.evaluate())











# tabd = TabularDataImporter("data.csv")
# tabd.preprocess_all()
# tabd.encodeCategorical()

# X_train, X_test, y_train, y_test = tabd.split_train_test_set(["LeistungPS", "Gesamtgewicht", "Drehmoment"], ["Beschleunigung"])

# print(X_train, y_train)

# normalizer = tf.keras.layers.Normalization(axis=-1)
# normalizer.adapt(np.array(X_train))
# horsepower = np.array(X_train)

# horsepower_normalizer = layers.Normalization(input_shape=[3,], axis=None)
# horsepower_normalizer.adapt(horsepower)
# horsepower_model = tf.keras.Sequential([
# horsepower_normalizer,
# layers.Dense(units=1)
# ])



# def build_and_compile_model(norm):
# model = keras.Sequential([
# norm,
# layers.Dense(64, activation='relu'),
# layers.Dense(64, activation='relu'),
# layers.Dense(1)
# ])

# model.compile(loss='mean_absolute_error',
#       optimizer=tf.keras.optimizers.Adam(0.001))
# return model


# dnn_horsepower_model = build_and_compile_model(horsepower_normalizer)
# dnn_horsepower_model.summary()


# history = dnn_horsepower_model.fit(
# X_train,
# y_train,
# validation_split=0.2,
# verbose=0, epochs=100)



# #x = tf.linspace(0.0, 650, 651)
# y = dnn_horsepower_model.predict(X_test)

# print(len(X_test["LeistungPS"].to_numpy()), len(y))
# print(X_train, y_train)

# def plot_horsepower(x, y):
# plt.scatter(X_train["LeistungPS"], y_train, label='Data')
# plt.scatter(x, y, color='k', label='Predictions')
# plt.xlabel('Horsepower')
# plt.ylabel('MPG')
# plt.legend()
# plt.show()

# plot_horsepower(X_test["LeistungPS"].to_numpy(), y)





